/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import org.jetbrains.annotations.Nullable;

class ResultUtils {
    private ResultUtils() {
    }

    public static String getBaseName(@Nullable String path) {
        int index;
        if (path != null && (index = path.lastIndexOf(47)) >= 0) {
            return path.substring(index + 1);
        }
        return path;
    }

    public static GitHubInfo parseRepoName(@Nullable String repo) {
        if (repo == null) {
            return null;
        }
        String[] repoBits = repo.replace("github.com/", "").split("/");
        if (repoBits.length >= 2) {
            return new GitHubInfo(repoBits[0], repoBits[1]);
        }
        return null;
    }

    public static String escapeHTML(String raw) {
        return raw.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
    }

    public static class GitHubInfo {
        public final String user;
        public final String repo;

        public GitHubInfo(String user, String repo) {
            this.user = user;
            this.repo = repo;
        }
    }
}

