/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GradleOutputParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR_COUNT_PATTERN = Pattern.compile("[\\d]+ error(s)?");

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        if (GradleOutputParser.ignoreMessage(line)) {
            return true;
        }
        if (line.endsWith("is an incubating feature.") || line.contains("has been deprecated and is scheduled to be removed in Gradle")) {
            return true;
        }
        if (line.startsWith("Total time: ") || line.startsWith("BUILD ")) {
            messages.add(new Message(Message.Kind.INFO, line, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
            return true;
        }
        return false;
    }

    private static boolean ignoreMessage(@NotNull String line) {
        return line.trim().equalsIgnoreCase("FAILED") || ERROR_COUNT_PATTERN.matcher(line).matches();
    }
}

