/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.ConfigurationFileManagerKt;
import com.intellij.configurationScript.DomKt;
import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\rJ\u0014\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0012\u0010\u0015\u001a\u00020\b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\fR-\u0010\u0005\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \t*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/configurationScript/ConfigurationFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "clearableLazyValues", "Lcom/intellij/util/containers/ConcurrentList;", "Lkotlin/Function0;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "yamlData", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lorg/snakeyaml/engine/v2/nodes/MappingNode;", "addFileListener", "findValueNode", "", "Lorg/snakeyaml/engine/v2/nodes/NodeTuple;", "namePath", "", "getConfigurationNode", "registerClearableLazyValue", "value", "Companion", "intellij.configurationScript"})
public final class ConfigurationFileManager {
    private final ConcurrentList<Function0<Unit>> clearableLazyValues = ContainerUtil.createConcurrentList();
    private final SynchronizedClearableLazy<MappingNode> yamlData;
    public static final Companion Companion = new Companion(null);

    public final void registerClearableLazyValue(@NotNull SynchronizedClearableLazy<?> value) {
        this.registerClearableLazyValue((Function0<Unit>)((Function0)new Function0<Unit>(value){
            final /* synthetic */ SynchronizedClearableLazy $value;

            public final void invoke() {
                this.$value.drop();
            }
            {
                this.$value = synchronizedClearableLazy;
                super(0);
            }
        }));
    }

    public final void registerClearableLazyValue(@NotNull Function0<Unit> value) {
        this.clearableLazyValues.add(value);
    }

    private final void addFileListener(Project project) {
        project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(this){
            final /* synthetic */ ConfigurationFileManager this$0;

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileCopyEvent) continue;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        if (((VFileCreateEvent)vFileEvent).isDirectory() || !ConfigurationFileManagerKt.isConfigurationFile(((VFileCreateEvent)vFileEvent).getChildName())) {
                            continue;
                        }
                    } else {
                        VirtualFile file;
                        if (vFileEvent.getFile() == null) {
                            continue;
                        }
                        if (!ConfigurationFileManagerKt.isConfigurationFile(file)) continue;
                    }
                    Iterable $this$forEach$iv = (Iterable)ConfigurationFileManager.access$getClearableLazyValues$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Function0 it = (Function0)element$iv;
                        boolean bl = false;
                        it.invoke();
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @Nullable
    public final MappingNode getConfigurationNode() {
        return (MappingNode)this.yamlData.getValue();
    }

    @Nullable
    public final List<NodeTuple> findValueNode(@NotNull String namePath) {
        Object object = (MappingNode)this.yamlData.getValue();
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        return DomKt.findValueNodeByPath(namePath, (List<NodeTuple>)object);
    }

    public ConfigurationFileManager(@NotNull Project project) {
        this.yamlData = new SynchronizedClearableLazy((Function0)new Function0<MappingNode>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final MappingNode invoke() {
                Path path = ConfigurationFileManagerKt.access$findConfigurationFile(this.$project);
                if (path == null) {
                    return null;
                }
                Path file = path;
                try {
                    InputStream inputStream;
                    InputStream inputStream2 = PathKt.inputStreamIfExists((Path)file);
                    if (inputStream2 == null) {
                        return null;
                    }
                    InputStream inputStream3 = inputStream = inputStream2;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    Closeable closeable = inputStream3;
                    int n = 0;
                    closeable = new InputStreamReader((InputStream)closeable, charset);
                    n = 8192;
                    boolean bl2 = false;
                    return ConfigurationFileManagerKt.doRead(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n));
                }
                catch (Throwable e) {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Cannot parse \"" + file + '\"', e);
                    return null;
                }
            }
            {
                this.$project = project;
                super(0);
            }
        });
        this.registerClearableLazyValue(this.yamlData);
        this.addFileListener(project);
    }

    public static final /* synthetic */ ConcurrentList access$getClearableLazyValues$p(ConfigurationFileManager $this) {
        return $this.clearableLazyValues;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/configurationScript/ConfigurationFileManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/configurationScript/ConfigurationFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.configurationScript"})
    public static final class Companion {
        @NotNull
        public final ConfigurationFileManager getInstance(@NotNull Project project) {
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            return (ConfigurationFileManager)$this$service$iv.getService(ConfigurationFileManager.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

