/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/lint/common/ReplaceCallFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "mySuggest", "", "(Ljava/lang/String;)V", "methodName", "getMethodName", "()Ljava/lang/String;", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "getName", "handleJava", "element", "handleKotlin", "intellij.lint"})
public final class ReplaceCallFix
extends DefaultLintQuickFix {
    private final String mySuggest;

    private final String getMethodName() {
        int start = StringsKt.startsWith$default((String)this.mySuggest, (String)"#", (boolean)false, (int)2, null) ? 1 : 0;
        int parameters = StringsKt.indexOf$default((CharSequence)this.mySuggest, (char)'(', (int)start, (boolean)false, (int)4, null);
        if (parameters == -1) {
            parameters = this.mySuggest.length();
        }
        String string = this.mySuggest;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, parameters);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        return "Call " + this.getMethodName() + " instead";
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        block3: {
            Language language;
            block2: {
                if (!startElement.isValid()) {
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(startElement)) {
                    return;
                }
                language = startElement.getLanguage();
                if (!Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) break block2;
                this.handleJava(startElement);
                break block3;
            }
            if (!Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) break block3;
            this.handleKotlin(startElement);
        }
    }

    private final void handleJava(PsiElement element) {
        String referenceName;
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false);
        if (psiMethodCallExpression == null) {
            return;
        }
        PsiMethodCallExpression methodCall = psiMethodCallExpression;
        PsiFile psiFile = methodCall.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
        if (document == null) {
            return;
        }
        Document document2 = document;
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        PsiElement psiElement = methodExpression.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        PsiElement referenceNameElement = psiElement;
        TextRange textRange = referenceNameElement.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange range = textRange;
        String name = this.getMethodName();
        if (StringsKt.startsWith$default((String)name, (String)"enforce", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"Permission", (boolean)false, (int)2, null) && (referenceName = methodExpression.getReferenceName()) != null && StringsKt.startsWith$default((String)referenceName, (String)"check", (boolean)false, (int)2, null)) {
            PsiExpressionList argumentList = methodCall.getArgumentList();
            int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
            document2.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
        }
        document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
    }

    private final void handleKotlin(PsiElement element) {
        PsiElement identifier;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, KtCallExpression.class, (boolean)false);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression methodCall = ktCallExpression;
        KtExpression methodExpression = methodCall.getCalleeExpression();
        if (methodExpression instanceof KtNameReferenceExpression && (identifier = ((KtNameReferenceExpression)methodExpression).getIdentifier()) != null) {
            KtValueArgumentList ktValueArgumentList;
            String referencedName;
            TextRange range = identifier.getTextRange();
            PsiFile psiFile = methodCall.getContainingFile();
            if (psiFile == null) {
                return;
            }
            PsiFile file = psiFile;
            Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
            if (document == null) {
                return;
            }
            Document document2 = document;
            String name = this.getMethodName();
            if (StringsKt.startsWith$default((String)name, (String)"enforce", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"Permission", (boolean)false, (int)2, null) && (referencedName = ((KtNameReferenceExpression)methodExpression).getReferencedName()) != null && StringsKt.startsWith$default((String)referencedName, (String)"check", (boolean)false, (int)2, null) && (ktValueArgumentList = methodCall.getValueArgumentList()) != null && (ktValueArgumentList = ktValueArgumentList.getTextRange()) != null) {
                KtValueArgumentList ktValueArgumentList2 = ktValueArgumentList;
                boolean bl = false;
                boolean bl2 = false;
                KtValueArgumentList range2 = ktValueArgumentList2;
                boolean bl3 = false;
                int offset = range2.getEndOffset() - 1;
                document2.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
            }
            document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
        }
    }

    public ReplaceCallFix(@NotNull String mySuggest) {
        super(null);
        this.mySuggest = mySuggest;
    }
}

