/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.ide.common.gradle.model.IdeTestOptions;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerImplBase;
import com.android.tools.idea.run.editor.AndroidDebuggerInfoProvider;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.testartifacts.instrumented.orchestrator.OrchestratorUtilsKt;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfiguration;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfigurationType;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.editor.ProcessNameReader;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.ConnectLLDBTask;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.Lists;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebugger
extends AndroidDebuggerImplBase<NativeAndroidDebuggerState> {
    public static final String ID = "Native";
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android %s Debugger (%d)";
    private static final Logger LOG = Logger.getInstance(NativeAndroidDebugger.class);
    private static ConsoleProvider ourConsoleProvider = null;

    public static void setConsoleProvider(@NotNull ConsoleProvider consoleProvider) {
        ourConsoleProvider = consoleProvider;
    }

    protected static ConsoleProvider getConsoleProvider() {
        return ourConsoleProvider;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return "Native Only";
    }

    @NotNull
    public NativeAndroidDebuggerState createState() {
        return new NativeAndroidDebuggerState();
    }

    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState>(runConfiguration.getProject(), runConfiguration instanceof AndroidRunConfiguration);
    }

    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @Nullable AndroidVersion version, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull String runConfigTypeId, @Nullable String packageNameOverride) {
        CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED = false;
        CidrDebuggerSettings.getInstance().LLDB_NATVIS_RENDERERS_ENABLED = false;
        ConnectLLDBTask baseConnector = new ConnectLLDBTask(env, applicationIds, facet, state, this, runConfigTypeId, packageNameOverride);
        IdeTestOptions.Execution executionType = Optional.ofNullable(AndroidModuleModel.get((AndroidFacet)facet)).map(AndroidModuleModel::getTestExecutionStrategy).orElse(IdeTestOptions.Execution.HOST);
        switch (executionType) {
            case ANDROID_TEST_ORCHESTRATOR: 
            case ANDROIDX_TEST_ORCHESTRATOR: {
                return OrchestratorUtilsKt.createReattachingDebugConnectorTask((ConnectDebuggerTask)baseConnector, (IdeTestOptions.Execution)executionType);
            }
        }
        return baseConnector;
    }

    public boolean supportsProject(@NotNull Project project) {
        return GradleProjectInfo.getInstance((Project)project).isBuildWithGradle() || NdkHelper.isNdkProject(project);
    }

    public void attachToClient(@NotNull Project project, @NotNull Client client, @Nullable RunConfiguration config2) {
        String processName = client.getClientData().getClientDescription();
        if (processName == null) {
            return;
        }
        Module module = this.findModuleForProcess(project, processName);
        if (module == null) {
            this.handleModuleNotFound(processName);
            return;
        }
        if (this.hasExistingSession(project, client)) {
            return;
        }
        DebuggerSession debuggerSession = NativeAndroidDebugger.findJdwpDebuggerSession((Project)project, (String)NativeAndroidDebugger.getClientDebugPort((Client)client));
        if (debuggerSession != null) {
            debuggerSession.getProcess().stop(false);
        }
        RunnerAndConfigurationSettings settings = this.createRunnerAndConfigurationSettings(project, module, client, this.getAndroidDebuggerState(config2));
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        ApplicationManager.getApplication().invokeLater(() -> ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)settings, (Executor)executor));
    }

    @Nullable
    protected Module findModuleForProcess(Project project, String packageName) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet : facets) {
            try {
                String facetPackageName = ApkProviderUtil.computePackageName((AndroidFacet)facet);
                if (packageName.startsWith(facetPackageName)) {
                    return facet.getModule();
                }
                if (!ProcessNameReader.hasGlobalProcess(facet, packageName)) continue;
                return facet.getModule();
            }
            catch (ApkProvisionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    protected void handleModuleNotFound(String packageName) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)("Cannot find module that matches process name " + packageName), (String)"Attach Failed"));
    }

    @NotNull
    protected RunnerAndConfigurationSettings createRunnerAndConfigurationSettings(@NotNull Project project, @NotNull Module module, @NotNull Client client, @Nullable AndroidDebuggerState state) {
        AndroidNativeAttachConfigurationType attachConfigurationType = AndroidNativeAttachConfigurationType.getInstance();
        ConfigurationFactory factory = attachConfigurationType.getFactory();
        String runConfigurationName = String.format(RUN_CONFIGURATION_NAME_PATTERN, this.getDisplayName(), client.getClientData().getPid());
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createRunConfiguration(runConfigurationName, factory);
        AndroidNativeAttachConfiguration configuration = (AndroidNativeAttachConfiguration)runSettings.getConfiguration();
        configuration.setClient(client);
        configuration.getAndroidDebuggerContext().setDebuggerType(this.getId());
        ((JavaRunConfigurationModule)configuration.getConfigurationModule()).setModule(module);
        configuration.setConsoleProvider(ourConsoleProvider);
        NativeAndroidDebuggerState targetState = (NativeAndroidDebuggerState)configuration.getAndroidDebuggerContext().getAndroidDebuggerState();
        if (state instanceof NativeAndroidDebuggerState) {
            NativeAndroidDebuggerState originState = (NativeAndroidDebuggerState)state;
            assert (targetState != null);
            targetState.setSymbolDirs(originState.getSymbolDirs());
            targetState.setUserStartupCommands(originState.getUserStartupCommands());
            targetState.setUserPostAttachCommands(originState.getUserPostAttachCommands());
        }
        return runSettings;
    }

    @Nullable
    protected AndroidDebuggerState getAndroidDebuggerState(@Nullable RunConfiguration config2) {
        if (config2 != null) {
            for (AndroidDebuggerInfoProvider provider : (AndroidDebuggerInfoProvider[])AndroidDebuggerInfoProvider.EP_NAME.getExtensions()) {
                if (!provider.supportsProject(config2.getProject())) continue;
                return provider.getSelectedAndroidDebuggerState(config2);
            }
        }
        return null;
    }

    protected static void detachXDebugSession(@NotNull XDebugSession debugSession) {
        RunContentDescriptor descriptor = debugSession.getRunContentDescriptor();
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null) {
            processHandler.detachProcess();
        }
    }

    protected boolean hasExistingSession(@NotNull Project project, @NotNull Client client) {
        XDebugSession nativeDebugSession = NativeAndroidDebugger.findNativeDebugSession(project, client);
        if (nativeDebugSession != null) {
            return NativeAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor());
        }
        return false;
    }

    @Nullable
    protected static XDebugSession findNativeDebugSession(@NotNull Project project, @NotNull Client client) {
        return NativeAndroidDebugger.findXDebugSession(project, (NotNullFunction<XDebugProcess, Boolean>)((NotNullFunction)debugProcess -> {
            if (!(debugProcess instanceof AndroidNativeAppDebugProcess)) {
                return false;
            }
            AndroidNativeAppDebugProcess nativeDebugProcess = (AndroidNativeAppDebugProcess)((Object)debugProcess);
            return nativeDebugProcess.getClient().getClientData().getPid() == client.getClientData().getPid();
        }));
    }

    @Nullable
    protected static XDebugSession findXDebugSession(@NotNull Project project, @NotNull NotNullFunction<XDebugProcess, Boolean> debugProcessFilter) {
        for (XDebugSession debugSession : XDebuggerManager.getInstance((Project)project).getDebugSessions()) {
            XDebugProcess debugProcess = debugSession.getDebugProcess();
            if (!((Boolean)debugProcessFilter.fun((Object)debugProcess)).booleanValue()) continue;
            return debugSession;
        }
        return null;
    }

    @NotNull
    public AndroidNativeAppDebugProcess newAndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @Nullable JdwpConnector jdwpConnector, @NotNull ProgressReporter progressReporter, boolean detachOnStop, @NotNull Abi lldbServerAbi) throws ExecutionException {
        return new AndroidNativeAppDebugProcess(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop, lldbServerAbi);
    }

    @NotNull
    protected static String prepareSetSettingsCommand(String ... options) {
        return "settings set " + StringUtil.join((String[])options, (String)" ");
    }

    @NotNull
    public List<String> getStartupCommands(@NotNull AndroidFacet facet, @Nullable Client client, @NotNull ProcessHandlerConsolePrinter printer) {
        ArrayList<String> cmds = new ArrayList<String>();
        Map<String, String> sourceMap = AndroidNativeAppDebugProcess.getSourceMap(facet);
        if (!sourceMap.isEmpty()) {
            ArrayList<String> arguments = new ArrayList<String>(sourceMap.size() * 2);
            for (Map.Entry<String, String> entry : sourceMap.entrySet()) {
                arguments.add("\"" + entry.getKey() + "\"");
                arguments.add("\"" + entry.getValue() + "\"");
            }
            String argumentsStr = StringUtil.join(arguments, (String)" ");
            LOG.info("Set target.source-map: " + argumentsStr);
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("target.source-map", argumentsStr));
        }
        Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("auto-confirm", "true"));
        Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("plugin.jit-loader.gdb.enable", "off"));
        if (SystemInfo.isWindows) {
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("use-source-cache", "false"));
        }
        return cmds;
    }

    @NotNull
    public List<String> getPostAttachCommands(@NotNull AndroidFacet facet, @Nullable Client client) {
        ArrayList cmds = Lists.newArrayList();
        cmds.add(NativeAndroidDebugger.prepareSetSettingsCommand("target.process.thread.step-avoid-regexp", "''"));
        cmds.add("type format add --format boolean jboolean");
        return cmds;
    }

    @NotNull
    private static String getFirstAbsolutePath(@NotNull Collection<VirtualFile> dirs) {
        VirtualFile f = (VirtualFile)ContainerUtil.getFirstItem(dirs);
        assert (f != null);
        return f.getPath();
    }
}

