/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.reference.JniReferenceContributorKt;
import com.android.tools.ndk.jni.reference.JvmReference;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\nH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/ndk/jni/reference/JvmMethodReference;", "Lcom/android/tools/ndk/jni/reference/JvmReference;", "jvmMethodId", "Lcom/android/tools/ndk/jni/model/JvmMethodId;", "element", "Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;", "(Lcom/android/tools/ndk/jni/model/JvmMethodId;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)V", "getJvmMethodId", "()Lcom/android/tools/ndk/jni/model/JvmMethodId;", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "", "isReferenceTo", "", "resolve", "android-ndk"})
public final class JvmMethodReference
extends JvmReference {
    @NotNull
    private final JvmMethodId jvmMethodId;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PsiElement resolve() {
        Object v3;
        Object object;
        block1: {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)((OCLiteralExpression)this.getElement()).getProject()).findClass(this.jvmMethodId.getClassName().getJava(), GlobalSearchScope.allScope((Project)((OCLiteralExpression)this.getElement()).getProject()));
            object = psiClass;
            if (psiClass == null) return null;
            List<JvmMethodInfo> list = JniUtilsKt.findAllMethodsByName((PsiClass)object, this.jvmMethodId.getMethodName());
            object = list;
            if (list == null) return null;
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JvmMethodInfo it = (JvmMethodInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMethodType(), (Object)this.jvmMethodId.getMethodType())) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        JvmMethodInfo jvmMethodInfo = v3;
        object = jvmMethodInfo;
        if (jvmMethodInfo == null) return null;
        PsiElement psiElement = ((JvmMethodInfo)object).getPsiElement();
        return psiElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        boolean bl;
        if (element instanceof PsiMethod) {
            JvmMethodInfo jvmMethodInfo = JvmMethodInfo.Companion.fromJavaMethod((PsiMethod)element);
            bl = Intrinsics.areEqual((Object)(jvmMethodInfo != null ? jvmMethodInfo.toJvmMethodId() : null), (Object)this.jvmMethodId);
        } else {
            bl = element instanceof PsiClass ? Intrinsics.areEqual((Object)this.jvmMethodId.getClassName(), (Object)FullyQualifiedClassName.Companion.fromJavaClass((PsiClass)element)) && Intrinsics.areEqual((Object)this.jvmMethodId.getMethodName(), (Object)"<init>") && Intrinsics.areEqual((Object)this.jvmMethodId.getMethodType(), (Object)"()V") : false;
        }
        return bl;
    }

    @Override
    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (Intrinsics.areEqual((Object)this.jvmMethodId.getMethodName(), (Object)"<init>")) {
            throw (Throwable)new IncorrectOperationException("Cannot rename '<init>'.");
        }
        return super.handleElementRename(newElementName);
    }

    @NotNull
    public final JvmMethodId getJvmMethodId() {
        return this.jvmMethodId;
    }

    public JvmMethodReference(@NotNull JvmMethodId jvmMethodId, @NotNull OCLiteralExpression element) {
        super(element, JniReferenceContributorKt.access$getContentTextRange$p(element), null);
        this.jvmMethodId = jvmMethodId;
    }
}

