/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.editorconfig.configmanagement.editor.EditorConfigEditorProvider;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigPreviewFile
extends LightVirtualFile
implements CodeStyleSettingsListener,
Disposable {
    private final Project myProject;
    private final String myOriginalPath;
    private final Document myDocument;

    EditorConfigPreviewFile(@NotNull Project project, @NotNull VirtualFile originalFile, @NotNull Document document) {
        super(originalFile.getName());
        this.myProject = project;
        this.myOriginalPath = originalFile.getPath();
        this.myDocument = document;
        Language language = EditorConfigEditorProvider.getLanguage(originalFile);
        if (language != null) {
            super.setLanguage(language);
        }
        super.setContent((Object)this, (CharSequence)this.myDocument.getText(), false);
        this.reformat();
        CodeStyleSettingsManager.getInstance((Project)project).addListener((CodeStyleSettingsListener)this);
    }

    @NotNull
    private PsiFile createPsi(@NotNull FileType fileType) {
        return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("preview", fileType, (CharSequence)this.myDocument.getText(), LocalTimeCounter.currentTime(), false);
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        this.reformat();
    }

    private void reformat() {
        if (!this.myProject.isInitialized()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            PsiFile originalPsiFile = this.resolveOriginalPsi();
            if (originalPsiFile != null) {
                CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)originalPsiFile);
                PsiFile psiFile = this.createPsi(originalPsiFile.getFileType());
                CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)settings, () -> CodeStyleManager.getInstance((Project)this.myProject).reformatText(psiFile, 0, psiFile.getTextLength()));
                this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)psiFile.getText());
            }
        }), EditorConfigBundle.message("command.name.reformat"), null);
    }

    @Nullable
    public PsiFile resolveOriginalPsi() {
        Document document;
        VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(this.myOriginalPath, new String[0]), (boolean)true);
        if (virtualFile != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
            return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        }
        return null;
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
    }
}

