/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.workers.WorkAction;
import org.gradle.workers.internal.AdapterWorkParameters;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ProvidesWorkResult;

public class AdapterWorkAction
implements WorkAction<AdapterWorkParameters>,
ProvidesWorkResult {
    private final AdapterWorkParameters parameters;
    private final Instantiator instantiator;
    private DefaultWorkResult workResult;

    @Inject
    public AdapterWorkAction(AdapterWorkParameters parameters, Instantiator instantiator) {
        this.parameters = parameters;
        this.instantiator = instantiator;
    }

    @Override
    public AdapterWorkParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void execute() {
        block8: {
            AdapterWorkParameters parameters = this.getParameters();
            String implementationClassName = parameters.getImplementationClassName();
            Class<?> actionClass = ClassLoaderUtils.classFromContextLoader(implementationClassName);
            Object action = this.instantiator.newInstance(actionClass, parameters.getParams());
            if (action instanceof Runnable) {
                ((Runnable)action).run();
                this.workResult = DefaultWorkResult.SUCCESS;
            } else if (action instanceof Callable) {
                try {
                    Object result = ((Callable)action).call();
                    if (result instanceof DefaultWorkResult) {
                        this.workResult = (DefaultWorkResult)result;
                        break block8;
                    }
                    if (result instanceof WorkResult) {
                        this.workResult = new DefaultWorkResult(((WorkResult)result).getDidWork(), null);
                        break block8;
                    }
                    throw new IllegalArgumentException("Worker actions must return a WorkResult.");
                }
                catch (Exception e) {
                    this.workResult = new DefaultWorkResult(true, e);
                }
            } else {
                throw new IllegalArgumentException("Worker actions must either implement Runnable or Callable<WorkResult>.");
            }
        }
    }

    @Override
    public DefaultWorkResult getWorkResult() {
        return this.workResult;
    }
}

