/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.provider.Provider;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.IdeWorkspace;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.idea.internal.IdeaModuleMetadata;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.Project;
import org.gradle.plugins.ide.idea.model.ProjectLibrary;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.util.ConfigureUtil;

public class IdeaProject
implements IdeWorkspace {
    private final org.gradle.api.Project project;
    private final XmlFileContentMerger ipr;
    private final ProjectStateRegistry projectPathRegistry;
    private final IdeArtifactRegistry artifactRegistry;
    private List<IdeaModule> modules;
    private String jdkName;
    private IdeaLanguageLevel languageLevel;
    private JavaVersion targetBytecodeVersion;
    private String vcs;
    private Set<String> wildcards = Sets.newLinkedHashSet();
    private RegularFileProperty outputFile;
    private Set<ProjectLibrary> projectLibraries = Sets.newLinkedHashSet();
    private PathFactory pathFactory;

    public IdeaProject(org.gradle.api.Project project, XmlFileContentMerger ipr) {
        this.project = project;
        this.ipr = ipr;
        ServiceRegistry services = ((ProjectInternal)project).getServices();
        this.projectPathRegistry = services.get(ProjectStateRegistry.class);
        this.artifactRegistry = services.get(IdeArtifactRegistry.class);
        this.outputFile = project.getObjects().fileProperty();
    }

    @Override
    public String getDisplayName() {
        return "IDEA project";
    }

    public Provider<RegularFile> getLocation() {
        return this.outputFile;
    }

    public org.gradle.api.Project getProject() {
        return this.project;
    }

    public XmlFileContentMerger getIpr() {
        return this.ipr;
    }

    public void ipr(Closure closure) {
        ConfigureUtil.configure(closure, this.ipr);
    }

    public void ipr(Action<? super XmlFileContentMerger> action) {
        action.execute(this.ipr);
    }

    public String getName() {
        return this.getOutputFile().getName().replaceFirst("\\.ipr$", "");
    }

    public List<IdeaModule> getModules() {
        return this.modules;
    }

    public void setModules(List<IdeaModule> modules) {
        this.modules = modules;
    }

    public String getJdkName() {
        return this.jdkName;
    }

    public void setJdkName(String jdkName) {
        this.jdkName = jdkName;
    }

    public IdeaLanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(IdeaLanguageLevel languageLevel) {
        this.languageLevel = languageLevel;
    }

    public void setLanguageLevel(Object languageLevel) {
        this.languageLevel = new IdeaLanguageLevel(languageLevel);
    }

    public JavaVersion getTargetBytecodeVersion() {
        return this.targetBytecodeVersion;
    }

    public void setTargetBytecodeVersion(JavaVersion targetBytecodeVersion) {
        this.targetBytecodeVersion = targetBytecodeVersion;
    }

    public String getVcs() {
        return this.vcs;
    }

    public void setVcs(String vcs) {
        this.vcs = vcs;
    }

    public Set<String> getWildcards() {
        return this.wildcards;
    }

    public void setWildcards(Set<String> wildcards) {
        this.wildcards = wildcards;
    }

    public File getOutputFile() {
        return ((RegularFile)this.outputFile.get()).getAsFile();
    }

    public void setOutputFile(File outputFile) {
        this.outputFile.set(outputFile);
    }

    public Set<ProjectLibrary> getProjectLibraries() {
        return this.projectLibraries;
    }

    public void setProjectLibraries(Set<ProjectLibrary> projectLibraries) {
        this.projectLibraries = projectLibraries;
    }

    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    public void setPathFactory(PathFactory pathFactory) {
        this.pathFactory = pathFactory;
    }

    public void mergeXmlProject(Project xmlProject) {
        this.ipr.getBeforeMerged().execute(xmlProject);
        xmlProject.configure(this.getModules(), this.getJdkName(), this.getLanguageLevel(), this.getTargetBytecodeVersion(), this.getWildcards(), this.getProjectLibraries(), this.getVcs());
        this.configureModulePaths(xmlProject);
        this.ipr.getWhenMerged().execute(xmlProject);
    }

    private void configureModulePaths(Project xmlProject) {
        ProjectComponentIdentifier thisProjectId = this.projectPathRegistry.stateFor(this.project).getComponentIdentifier();
        for (IdeArtifactRegistry.Reference<IdeaModuleMetadata> reference : this.artifactRegistry.getIdeProjects(IdeaModuleMetadata.class)) {
            BuildIdentifier otherBuildId = reference.getOwningProject().getBuild();
            if (thisProjectId.getBuild().equals(otherBuildId)) continue;
            xmlProject.addModulePath(reference.get().getFile());
        }
    }
}

