/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.collect.FluentIterable;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.model.RuleSource;

@ThreadSafe
public class ModelRuleSourceDetector {
    private static final Comparator<Class<?>> COMPARE_BY_CLASS_NAME = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> left, Class<?> right) {
            return left.getName().compareTo(right.getName());
        }
    };
    final LoadingCache<Class<?>, Collection<Reference<Class<? extends RuleSource>>>> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Collection<Reference<Class<? extends RuleSource>>>>(){

        public Collection<Reference<Class<? extends RuleSource>>> load(Class<?> container) throws Exception {
            if (ModelRuleSourceDetector.this.isRuleSource(container)) {
                Class castClass = (Class)Cast.uncheckedCast(container);
                return ImmutableSet.of(new WeakReference<Class>(castClass));
            }
            Class<?>[] declaredClasses = container.getDeclaredClasses();
            if (declaredClasses.length == 0) {
                return Collections.emptySet();
            }
            Class[] sortedDeclaredClasses = new Class[declaredClasses.length];
            System.arraycopy(declaredClasses, 0, sortedDeclaredClasses, 0, declaredClasses.length);
            Arrays.sort(sortedDeclaredClasses, COMPARE_BY_CLASS_NAME);
            ImmutableList.Builder found = ImmutableList.builder();
            for (Class declaredClass : sortedDeclaredClasses) {
                if (!ModelRuleSourceDetector.this.isRuleSource(declaredClass)) continue;
                Class castClass = (Class)Cast.uncheckedCast(declaredClass);
                found.add(new WeakReference<Class>(castClass));
            }
            return found.build();
        }
    });

    public Iterable<Class<? extends RuleSource>> getDeclaredSources(Class<?> container) {
        try {
            return FluentIterable.from((Iterable)((Iterable)this.cache.get(container))).transform((Function)new Function<Reference<Class<? extends RuleSource>>, Class<? extends RuleSource>>(){

                public Class<? extends RuleSource> apply(Reference<Class<? extends RuleSource>> input) {
                    return input.get();
                }
            }).filter(Predicates.notNull());
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public boolean hasRules(Class<?> container) {
        return !Iterables.isEmpty(this.getDeclaredSources(container));
    }

    private boolean isRuleSource(Class<?> clazz) {
        return RuleSource.class.isAssignableFrom(clazz);
    }
}

