/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionEvent;

public class GarbageCollectionStats {
    private final double gcRate;
    private final int usedPercent;
    private final long maxSizeInBytes;
    private final long eventCount;

    private GarbageCollectionStats(double gcRate, long usedSizeInBytes, long maxSizeInBytes, long eventCount) {
        this.gcRate = gcRate;
        this.usedPercent = maxSizeInBytes > 0L ? NumberUtil.percentOf(usedSizeInBytes, maxSizeInBytes) : 0;
        this.maxSizeInBytes = maxSizeInBytes;
        this.eventCount = eventCount;
    }

    static GarbageCollectionStats forHeap(Collection<GarbageCollectionEvent> events) {
        if (events.isEmpty()) {
            return GarbageCollectionStats.noData();
        }
        return new GarbageCollectionStats(GarbageCollectionStats.calculateRate(events), GarbageCollectionStats.calculateAverageUsage(events), GarbageCollectionStats.findMaxSize(events), events.size());
    }

    static GarbageCollectionStats forNonHeap(Collection<GarbageCollectionEvent> events) {
        if (events.isEmpty()) {
            return GarbageCollectionStats.noData();
        }
        return new GarbageCollectionStats(0.0, GarbageCollectionStats.calculateAverageUsage(events), GarbageCollectionStats.findMaxSize(events), events.size());
    }

    private static GarbageCollectionStats noData() {
        return new GarbageCollectionStats(0.0, 0L, -1L, 0L);
    }

    private static double calculateRate(Collection<GarbageCollectionEvent> events) {
        if (events.size() < 2) {
            return 0.0;
        }
        GarbageCollectionEvent first = events.iterator().next();
        GarbageCollectionEvent last = (GarbageCollectionEvent)Iterables.getLast(events);
        long gcCountDelta = last.getCount() - first.getCount();
        long timeDelta = TimeUnit.MILLISECONDS.toSeconds(last.getTimestamp() - first.getTimestamp());
        return (double)gcCountDelta / (double)timeDelta;
    }

    private static long calculateAverageUsage(Collection<GarbageCollectionEvent> events) {
        long sum = 0L;
        for (GarbageCollectionEvent event : events) {
            sum += event.getUsage().getUsed();
        }
        return sum / (long)events.size();
    }

    private static long findMaxSize(Collection<GarbageCollectionEvent> events) {
        GarbageCollectionEvent first = events.iterator().next();
        return first.getUsage().getMax();
    }

    public double getGcRate() {
        return this.gcRate;
    }

    public int getUsedPercent() {
        return this.usedPercent;
    }

    public long getMaxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    public boolean isValid() {
        return this.eventCount >= 5L && this.maxSizeInBytes > 0L;
    }
}

