/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.internal.FileUtils;
import org.gradle.launcher.daemon.context.DaemonContext;

public class DaemonCompatibilitySpec
implements ExplainingSpec<DaemonContext> {
    private final DaemonContext desiredContext;

    public DaemonCompatibilitySpec(DaemonContext desiredContext) {
        this.desiredContext = desiredContext;
    }

    @Override
    public boolean isSatisfiedBy(DaemonContext potentialContext) {
        return this.whyUnsatisfied(potentialContext) == null;
    }

    @Override
    public String whyUnsatisfied(DaemonContext context) {
        if (!this.javaHomeMatches(context)) {
            return "Java home is different.\n" + this.description(context);
        }
        if (!this.daemonOptsMatch(context)) {
            return "At least one daemon option is different.\n" + this.description(context);
        }
        if (!this.priorityMatches(context)) {
            return "Process priority is different.\n" + this.description(context);
        }
        return null;
    }

    private String description(DaemonContext context) {
        return "Wanted: " + this + "\nActual: " + context + "\n";
    }

    private boolean daemonOptsMatch(DaemonContext potentialContext) {
        return potentialContext.getDaemonOpts().containsAll(this.desiredContext.getDaemonOpts()) && potentialContext.getDaemonOpts().size() == this.desiredContext.getDaemonOpts().size();
    }

    private boolean javaHomeMatches(DaemonContext potentialContext) {
        return FileUtils.canonicalize(potentialContext.getJavaHome()).equals(FileUtils.canonicalize(this.desiredContext.getJavaHome()));
    }

    private boolean priorityMatches(DaemonContext context) {
        return this.desiredContext.getPriority() == context.getPriority();
    }

    public String toString() {
        return this.desiredContext.toString();
    }
}

