/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.rubygrapefruit.platform.file.FileWatcher;
import org.gradle.internal.impldep.com.google.common.collect.HashMultiset;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Multiset;
import org.gradle.internal.impldep.com.google.common.collect.Multisets;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchRootUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalFileWatcherUpdater
implements FileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchicalFileWatcherUpdater.class);
    private final Map<String, ImmutableList<Path>> watchedRootsForSnapshot = new HashMap<String, ImmutableList<Path>>();
    private final Multiset<Path> shouldWatchDirectories = HashMultiset.create();
    private final Set<Path> watchedRoots = new HashSet<Path>();
    private final FileWatcher watcher;
    private Path projectRootDirectory;
    private String projectRootDirectoryPrefix;

    public HierarchicalFileWatcherUpdater(FileWatcher watcher) {
        this.watcher = watcher;
    }

    @Override
    public void changed(Collection<CompleteFileSystemLocationSnapshot> removedSnapshots, Collection<CompleteFileSystemLocationSnapshot> addedSnapshots) {
        removedSnapshots.forEach(snapshot -> {
            ImmutableList<Path> previouslyWatchedRootsForSnapshot = this.watchedRootsForSnapshot.remove(snapshot.getAbsolutePath());
            Multisets.removeOccurrences(this.shouldWatchDirectories, previouslyWatchedRootsForSnapshot);
        });
        addedSnapshots.forEach(snapshot -> {
            ImmutableList<Path> directoriesToWatch = WatchRootUtil.getDirectoriesToWatch(snapshot);
            this.shouldWatchDirectories.addAll(directoriesToWatch);
            this.watchedRootsForSnapshot.put(snapshot.getAbsolutePath(), directoriesToWatch);
        });
        this.updateWatchedDirectories();
    }

    @Override
    public void updateProjectRootDirectory(File projectRoot) {
        this.projectRootDirectory = projectRoot.toPath().toAbsolutePath();
        this.projectRootDirectoryPrefix = this.projectRootDirectory.toString() + File.separator;
        this.updateWatchedDirectories();
    }

    private void updateWatchedDirectories() {
        Set<Path> directoriesToWatch = this.shouldWatchDirectories.elementSet().stream().map(shouldWatchDirectory -> this.projectRootDirectoryPrefix != null && shouldWatchDirectory.toString().startsWith(this.projectRootDirectoryPrefix) ? this.projectRootDirectory : shouldWatchDirectory).collect(Collectors.toSet());
        this.updateWatchedDirectories(WatchRootUtil.resolveRootsToWatch(directoriesToWatch));
    }

    private void updateWatchedDirectories(Set<Path> newWatchRoots) {
        HashSet<Path> watchRootsToRemove = new HashSet<Path>(this.watchedRoots);
        if (newWatchRoots.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        watchRootsToRemove.removeAll(newWatchRoots);
        newWatchRoots.removeAll(this.watchedRoots);
        if (newWatchRoots.isEmpty() && watchRootsToRemove.isEmpty()) {
            return;
        }
        LOGGER.info("Watching {} directory hierarchies to track changes", (Object)newWatchRoots.size());
        if (!watchRootsToRemove.isEmpty()) {
            this.watcher.stopWatching(watchRootsToRemove.stream().map(Path::toFile).collect(Collectors.toList()));
            this.watchedRoots.removeAll(watchRootsToRemove);
        }
        if (!newWatchRoots.isEmpty()) {
            this.watcher.startWatching(newWatchRoots.stream().map(Path::toFile).collect(Collectors.toList()));
            this.watchedRoots.addAll(newWatchRoots);
        }
    }
}

