/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.state.ManagedFactory;

public class ManagedTypeFactory
implements ManagedFactory {
    private final Constructor<?> constructor;

    public ManagedTypeFactory(Class<?> type) {
        try {
            this.constructor = type.getConstructor(Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The class " + type.getSimpleName() + " does not appear to a be a generated managed class.", e);
        }
    }

    @Override
    public <T> T fromState(Class<T> type, Object state) {
        if (!type.isAssignableFrom(this.constructor.getDeclaringClass())) {
            return null;
        }
        try {
            return type.cast(this.constructor.newInstance(state));
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
        catch (Exception e) {
            throw new ObjectInstantiationException(type, (Throwable)e);
        }
    }

    @Override
    public int getId() {
        return Objects.hashCode((Object[])new Object[]{this.constructor.getDeclaringClass().getName()});
    }
}

