/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ForeignBuildIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIncludedBuild
extends AbstractBuildState
implements IncludedBuildState,
IncludedBuild,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludedBuild.class);
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildDefinition buildDefinition;
    private final boolean isImplicit;
    private final BuildState owner;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final GradleLauncher gradleLauncher;
    private Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules;

    public DefaultIncludedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner, WorkerLeaseRegistry.WorkerLease parentLease) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.isImplicit = isImplicit;
        this.owner = owner;
        this.parentLease = parentLease;
        this.gradleLauncher = owner.getNestedBuildFactory().nestedInstance(buildDefinition.newInstance(), this);
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public File getRootDirectory() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public boolean isImplicitBuild() {
        return this.isImplicit;
    }

    @Override
    public IncludedBuild getModel() {
        return this;
    }

    @Override
    public File getProjectDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object)path);
        return new IncludedBuildTaskReference(this, path);
    }

    @Override
    public String getName() {
        return this.identityPath.getName();
    }

    @Override
    public NestedBuildFactory getNestedBuildFactory() {
        return this.gradleLauncher.getGradle().getServices().get(NestedBuildFactory.class);
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        if (this.isImplicit) {
            super.assertCanAdd(includedBuildSpec);
        }
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildIdentifier.getName());
    }

    @Override
    public Path getIdentityPathForProject(Path projectPath) {
        return this.getIdentityPath().append(projectPath);
    }

    @Override
    public Action<? super DependencySubstitutions> getRegisteredDependencySubstitutions() {
        return this.buildDefinition.getDependencySubstitutions();
    }

    @Override
    public synchronized Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
        if (this.availableModules == null) {
            GradleInternal gradle = this.getConfiguredBuild();
            this.availableModules = Sets.newLinkedHashSet();
            for (Project project : gradle.getRootProject().getAllprojects()) {
                this.registerProject(this.availableModules, (ProjectInternal)project);
            }
        }
        return this.availableModules;
    }

    private void registerProject(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules, ProjectInternal project) {
        LocalComponentRegistry localComponentRegistry = project.getServices().get(LocalComponentRegistry.class);
        DefaultProjectComponentIdentifier projectIdentifier = new DefaultProjectComponentIdentifier(this.buildIdentifier, project.getIdentityPath(), project.getProjectPath(), project.getName());
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(projectIdentifier);
        ModuleVersionIdentifier moduleId = originalComponent.getModuleVersionId();
        LOGGER.info("Registering " + project + " in composite build. Will substitute for module '" + moduleId.getModule() + "'.");
        availableModules.add(Pair.of(moduleId, projectIdentifier));
    }

    @Override
    public ProjectComponentIdentifier idToReferenceProjectFromAnotherBuild(ProjectComponentIdentifier identifier) {
        DefaultProjectComponentIdentifier original = (DefaultProjectComponentIdentifier)identifier;
        return new DefaultProjectComponentIdentifier(new ForeignBuildIdentifier(this.buildIdentifier.getName(), this.getName()), original.getIdentityPath(), original.projectPath(), original.getProjectName());
    }

    @Override
    public SettingsInternal loadSettings() {
        return this.gradleLauncher.getLoadedSettings();
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.gradleLauncher.getGradle().getSettings();
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.gradleLauncher.getConfiguredBuild();
    }

    @Override
    public <T> T withState(Transformer<T, ? super GradleInternal> action) {
        return action.transform(this.gradleLauncher.getGradle());
    }

    @Override
    public void finishBuild() {
        this.gradleLauncher.finishBuild();
    }

    @Override
    public synchronized void addTasks(Iterable<String> taskPaths) {
        this.gradleLauncher.scheduleTasks(taskPaths);
    }

    @Override
    public synchronized void execute(Iterable<String> tasks, Object listener) {
        this.gradleLauncher.addListener(listener);
        this.gradleLauncher.scheduleTasks(tasks);
        WorkerLeaseService workerLeaseService = this.gradleLauncher.getGradle().getServices().get(WorkerLeaseService.class);
        workerLeaseService.withSharedLease(this.parentLease, new Runnable(){

            @Override
            public void run() {
                DefaultIncludedBuild.this.gradleLauncher.executeTasks();
            }
        });
    }

    @Override
    public void stop() {
        this.gradleLauncher.stop();
    }
}

