/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.cache.AsyncCacheAccess;
import org.gradle.cache.CacheDecorator;
import org.gradle.cache.FileAccess;
import org.gradle.cache.FileIntegrityViolationException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.InsufficientLockModeException;
import org.gradle.cache.LockOptions;
import org.gradle.cache.LockTimeoutException;
import org.gradle.cache.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.CacheAccessWorker;
import org.gradle.cache.internal.CacheCleanupAction;
import org.gradle.cache.internal.CacheCoordinator;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultMultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.FixedExclusiveModeCrossProcessCacheAccess;
import org.gradle.cache.internal.FixedSharedModeCrossProcessCacheAccess;
import org.gradle.cache.internal.LockOnDemandCrossProcessCacheAccess;
import org.gradle.cache.internal.NoLockingCacheAccess;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.cache.internal.cacheops.CacheAccessOperationsStack;
import org.gradle.internal.Cast;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultCacheAccess
implements CacheCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCacheAccess.class);
    private static final Runnable NO_OP = () -> {};
    private final String cacheDisplayName;
    private final File baseDir;
    private final CacheCleanupAction cleanupAction;
    private final ExecutorFactory executorFactory;
    private final FileAccess fileAccess;
    private final Map<String, IndexedCacheEntry<?, ?>> caches = new HashMap();
    private final AbstractCrossProcessCacheAccess crossProcessCacheAccess;
    private final CacheAccessOperationsStack operations;
    private ManagedExecutor cacheUpdateExecutor;
    private CacheAccessWorker cacheAccessWorker;
    private final Lock stateLock = new ReentrantLock();
    private final Condition condition = this.stateLock.newCondition();
    private boolean open;
    private Thread owner;
    private FileLock fileLock;
    private FileLock.State stateAtOpen;
    private Runnable fileLockHeldByOwner;
    private int cacheClosedCount;

    public DefaultCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, File baseDir, FileLockManager lockManager, CacheInitializationAction initializationAction, CacheCleanupAction cleanupAction, ExecutorFactory executorFactory) {
        this.cacheDisplayName = cacheDisplayName;
        this.baseDir = baseDir;
        this.cleanupAction = cleanupAction;
        this.executorFactory = executorFactory;
        this.operations = new CacheAccessOperationsStack();
        Action<FileLock> onFileLockAcquireAction = this::afterLockAcquire;
        Action<FileLock> onFileLockReleaseAction = this::beforeLockRelease;
        switch (lockOptions.getMode()) {
            case Shared: {
                this.crossProcessCacheAccess = new FixedSharedModeCrossProcessCacheAccess(cacheDisplayName, lockTarget, lockOptions, lockManager, initializationAction, onFileLockAcquireAction, onFileLockReleaseAction);
                this.fileAccess = new UnitOfWorkFileAccess();
                break;
            }
            case Exclusive: {
                this.crossProcessCacheAccess = new FixedExclusiveModeCrossProcessCacheAccess(cacheDisplayName, lockTarget, lockOptions, lockManager, initializationAction, onFileLockAcquireAction, onFileLockReleaseAction);
                this.fileAccess = new UnitOfWorkFileAccess();
                break;
            }
            case OnDemand: {
                this.crossProcessCacheAccess = new LockOnDemandCrossProcessCacheAccess(cacheDisplayName, lockTarget, lockOptions.withMode(FileLockManager.LockMode.Exclusive), lockManager, this.stateLock, initializationAction, onFileLockAcquireAction, onFileLockReleaseAction);
                this.fileAccess = new UnitOfWorkFileAccess();
                break;
            }
            case None: {
                this.crossProcessCacheAccess = new NoLockingCacheAccess(this::notifyFinish);
                this.fileAccess = TransparentFileAccess.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private synchronized AsyncCacheAccess getCacheAccessWorker() {
        if (this.cacheAccessWorker == null) {
            this.cacheAccessWorker = new CacheAccessWorker(this.cacheDisplayName, this);
            this.cacheUpdateExecutor = this.executorFactory.create("Cache worker for " + this.cacheDisplayName);
            this.cacheUpdateExecutor.execute(this.cacheAccessWorker);
        }
        return this.cacheAccessWorker;
    }

    @Override
    public void open() {
        this.stateLock.lock();
        try {
            if (this.open) {
                throw new IllegalStateException("Cache is already open.");
            }
            this.takeOwnershipNow();
            try {
                this.crossProcessCacheAccess.open();
                this.open = true;
            }
            finally {
                this.releaseOwnership();
            }
        }
        catch (Throwable throwable) {
            this.crossProcessCacheAccess.close();
            throw UncheckedException.throwAsUncheckedException(throwable);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public synchronized void close() {
        if (this.cacheAccessWorker != null) {
            this.cacheAccessWorker.stop();
            this.cacheAccessWorker = null;
        }
        if (this.cacheUpdateExecutor != null) {
            this.cacheUpdateExecutor.stop();
            this.cacheUpdateExecutor = null;
        }
        this.stateLock.lock();
        try {
            this.takeOwnershipNow();
            if (this.fileLockHeldByOwner != null) {
                this.fileLockHeldByOwner.run();
            }
            this.crossProcessCacheAccess.close();
            if (this.cleanupAction != null) {
                try {
                    if (this.cleanupAction.requiresCleanup()) {
                        this.cleanupAction.cleanup();
                    }
                }
                catch (Exception e) {
                    LOG.debug("Cache {} could not run cleanup action {}", (Object)this.cacheDisplayName, (Object)this.cleanupAction);
                }
            }
            if (this.cacheClosedCount != 1) {
                LOG.debug("Cache {} was closed {} times.", (Object)this.cacheDisplayName, (Object)this.cacheClosedCount);
            }
        }
        finally {
            this.owner = null;
            this.fileLockHeldByOwner = null;
            this.stateLock.unlock();
        }
    }

    @Override
    public <T> T withFileLock(Factory<? extends T> action) {
        return this.crossProcessCacheAccess.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.crossProcessCacheAccess.withFileLock(Factories.toFactory(action));
    }

    @Override
    public void useCache(Runnable action) {
        this.useCache(Factories.toFactory(action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(Factory<? extends T> factory) {
        boolean wasStarted;
        this.stateLock.lock();
        try {
            this.takeOwnership();
            try {
                wasStarted = this.onStartWork();
            }
            catch (Throwable t) {
                this.releaseOwnership();
                throw UncheckedException.throwAsUncheckedException(t);
            }
        }
        finally {
            this.stateLock.unlock();
        }
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.stateLock.lock();
            try {
                try {
                    if (wasStarted) {
                        this.onEndWork();
                    }
                }
                finally {
                    this.releaseOwnership();
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    private void takeOwnership() {
        while (this.owner != null && this.owner != Thread.currentThread()) {
            try {
                this.condition.await();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        this.owner = Thread.currentThread();
        this.operations.pushCacheAction();
    }

    private void takeOwnershipNow() {
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException(String.format("Cannot take ownership of %s as it is currently being used by another thread.", this.cacheDisplayName));
        }
        this.owner = Thread.currentThread();
        this.operations.pushCacheAction();
    }

    private void releaseOwnership() {
        this.operations.popCacheAction();
        if (!this.operations.isInCacheAction()) {
            this.owner = null;
            this.condition.signalAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MultiProcessSafePersistentIndexedCache<K, V> newCache(PersistentIndexedCacheParameters<K, V> parameters) {
        this.stateLock.lock();
        IndexedCacheEntry<K, V> entry = (IndexedCacheEntry<K, V>)Cast.uncheckedCast(this.caches.get(parameters.getCacheName()));
        try {
            if (entry == null) {
                File cacheFile = this.findCacheFile(parameters);
                LOG.debug("Creating new cache for {}, path {}, access {}", new Object[]{parameters.getCacheName(), cacheFile, this});
                Factory indexedCacheFactory = () -> this.doCreateCache(cacheFile, parameters.getKeySerializer(), parameters.getValueSerializer());
                MultiProcessSafePersistentIndexedCache indexedCache = new DefaultMultiProcessSafePersistentIndexedCache(indexedCacheFactory, this.fileAccess);
                CacheDecorator decorator = parameters.getCacheDecorator();
                if (decorator != null) {
                    indexedCache = decorator.decorate(cacheFile.getAbsolutePath(), parameters.getCacheName(), indexedCache, this.crossProcessCacheAccess, this.getCacheAccessWorker());
                    if (this.fileLock == null) {
                        this.useCache(NO_OP);
                    }
                }
                entry = new IndexedCacheEntry<K, V>(parameters, indexedCache);
                this.caches.put(parameters.getCacheName(), entry);
                if (this.fileLock != null) {
                    indexedCache.afterLockAcquire(this.stateAtOpen);
                }
            } else {
                entry.assertCompatibleCacheParameters(parameters);
            }
            MultiProcessSafePersistentIndexedCache multiProcessSafePersistentIndexedCache = entry.getCache();
            return multiProcessSafePersistentIndexedCache;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private <K, V> File findCacheFile(PersistentIndexedCacheParameters<K, V> parameters) {
        return new File(this.baseDir, parameters.getCacheName() + ".bin");
    }

    @Override
    public <K, V> boolean cacheExists(PersistentIndexedCacheParameters<K, V> parameters) {
        return this.findCacheFile(parameters).exists();
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new BTreePersistentIndexedCache<K, V>(cacheFile, keySerializer, valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterLockAcquire(FileLock fileLock) {
        assert (this.fileLock == null);
        this.fileLock = fileLock;
        this.stateAtOpen = fileLock.getState();
        this.takeOwnershipNow();
        try {
            for (IndexedCacheEntry<?, ?> entry : this.caches.values()) {
                entry.getCache().afterLockAcquire(this.stateAtOpen);
            }
        }
        finally {
            this.releaseOwnership();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeLockRelease(FileLock fileLock) {
        assert (this.fileLock == fileLock);
        try {
            ++this.cacheClosedCount;
            this.takeOwnershipNow();
            try {
                this.notifyFinish();
                FileLock.State state = fileLock.getState();
                for (IndexedCacheEntry<?, ?> entry : this.caches.values()) {
                    entry.getCache().beforeLockRelease(state);
                }
            }
            finally {
                this.releaseOwnership();
            }
        }
        finally {
            this.fileLock = null;
            this.stateAtOpen = null;
        }
    }

    private void notifyFinish() {
        for (IndexedCacheEntry<?, ?> entry : this.caches.values()) {
            entry.getCache().finishWork();
        }
    }

    private boolean onStartWork() {
        if (this.fileLockHeldByOwner != null) {
            return false;
        }
        this.fileLockHeldByOwner = this.crossProcessCacheAccess.acquireFileLock();
        return true;
    }

    private boolean onEndWork() {
        if (this.fileLockHeldByOwner == null) {
            return false;
        }
        try {
            this.fileLockHeldByOwner.run();
        }
        finally {
            this.fileLockHeldByOwner = null;
        }
        return true;
    }

    private FileLock getFileLock() {
        this.stateLock.lock();
        try {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException(String.format("The %s has not been locked for this thread. File lock: %s, owner: %s", this.cacheDisplayName, this.fileLock != null, this.owner));
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return this.fileLock;
    }

    Thread getOwner() {
        return this.owner;
    }

    FileAccess getFileAccess() {
        return this.fileAccess;
    }

    @VisibleForTesting
    static class InvalidCacheReuseException
    extends GradleException {
        InvalidCacheReuseException(String message) {
            super(message);
        }
    }

    private static class IndexedCacheEntry<K, V> {
        private final MultiProcessSafePersistentIndexedCache<K, V> cache;
        private final PersistentIndexedCacheParameters<K, V> parameters;

        IndexedCacheEntry(PersistentIndexedCacheParameters<K, V> parameters, MultiProcessSafePersistentIndexedCache<K, V> cache) {
            this.parameters = parameters;
            this.cache = cache;
        }

        public MultiProcessSafePersistentIndexedCache<K, V> getCache() {
            return this.cache;
        }

        public PersistentIndexedCacheParameters<K, V> getParameters() {
            return this.parameters;
        }

        void assertCompatibleCacheParameters(PersistentIndexedCacheParameters<K, V> parameters) {
            ArrayList<String> faultMessages = new ArrayList<String>();
            this.checkCacheNameMatch(faultMessages, parameters.getCacheName());
            this.checkCompatibleKeySerializer(faultMessages, parameters.getKeySerializer());
            this.checkCompatibleValueSerializer(faultMessages, parameters.getValueSerializer());
            this.checkCompatibleCacheDecorator(faultMessages, parameters.getCacheDecorator());
            if (!faultMessages.isEmpty()) {
                String lineSeparator = SystemProperties.getInstance().getLineSeparator();
                String faultMessage = CollectionUtils.join(lineSeparator, faultMessages);
                throw new InvalidCacheReuseException("The cache couldn't be reused because of the following mismatch:" + lineSeparator + faultMessage);
            }
        }

        private void checkCacheNameMatch(Collection<String> faultMessages, String cacheName) {
            if (!Objects.equal((Object)cacheName, (Object)this.parameters.getCacheName())) {
                faultMessages.add(String.format(" * Requested cache name (%s) doesn't match current cache name (%s)", cacheName, this.parameters.getCacheName()));
            }
        }

        private void checkCompatibleKeySerializer(Collection<String> faultMessages, Serializer<K> keySerializer) {
            if (!Objects.equal(keySerializer, this.parameters.getKeySerializer())) {
                faultMessages.add(String.format(" * Requested key serializer type (%s) doesn't match current cache type (%s)", keySerializer.getClass().getCanonicalName(), this.parameters.getKeySerializer().getClass().getCanonicalName()));
            }
        }

        private void checkCompatibleValueSerializer(Collection<String> faultMessages, Serializer<V> valueSerializer) {
            if (!Objects.equal(valueSerializer, this.parameters.getValueSerializer())) {
                faultMessages.add(String.format(" * Requested value serializer type (%s) doesn't match current cache type (%s)", valueSerializer.getClass().getCanonicalName(), this.parameters.getValueSerializer().getClass().getCanonicalName()));
            }
        }

        private void checkCompatibleCacheDecorator(Collection<String> faultMessages, CacheDecorator cacheDecorator) {
            if (!Objects.equal((Object)cacheDecorator, (Object)this.parameters.getCacheDecorator())) {
                faultMessages.add(String.format(" * Requested cache decorator type (%s) doesn't match current cache type (%s)", cacheDecorator, this.parameters.getCacheDecorator()));
            }
        }
    }

    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        public String toString() {
            return DefaultCacheAccess.this.cacheDisplayName;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException {
            return DefaultCacheAccess.this.getFileLock().readFile(action);
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getFileLock().updateFile(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getFileLock().writeFile(action);
        }
    }

    private static class TransparentFileAccess
    implements FileAccess {
        private static final FileAccess INSTANCE = new TransparentFileAccess();

        private TransparentFileAccess() {
        }

        @Override
        public <T> T readFile(Callable<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException, InsufficientLockModeException {
            try {
                return action.call();
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException, InsufficientLockModeException {
            return action.create();
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException, FileIntegrityViolationException, InsufficientLockModeException {
            action.run();
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException, InsufficientLockModeException {
            action.run();
        }
    }
}

