/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.userinput;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.userinput.UserInputReader;

public class DefaultUserInputReader
implements UserInputReader {
    private static final char UNIX_NEW_LINE = '\n';
    private static final char WINDOWS_NEW_LINE = '\r';
    private final Reader br = new InputStreamReader(System.in);

    @Override
    public String readInput() {
        StringBuilder out = new StringBuilder();
        try {
            int c;
            while (true) {
                if (this.isEOF(c = this.br.read())) {
                    return null;
                }
                if (this.isLineSeparator((char)c)) break;
                out.append((char)c);
            }
            if (c == 13 && '\n' != (char)this.br.read()) {
                throw new RuntimeException("Unexpected");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toString();
    }

    private boolean isEOF(int c) {
        return c == 4 || c == -1;
    }

    private boolean isLineSeparator(char c) {
        return c == '\n' || c == '\r';
    }
}

