/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.recomp.ClasspathEntryChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.util.Alignment;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.gradle.work.FileChange;

abstract class AbstractRecompilationSpecProvider
implements RecompilationSpecProvider {
    private final Deleter deleter;
    protected final FileOperations fileOperations;
    protected final FileTree sourceTree;

    public AbstractRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sourceTree) {
        this.deleter = deleter;
        this.fileOperations = fileOperations;
        this.sourceTree = sourceTree;
    }

    protected boolean deleteStaleFilesIn(PatternSet filesToDelete, File destinationDir) {
        if (filesToDelete == null || filesToDelete.isEmpty() || destinationDir == null) {
            return false;
        }
        Set<File> toDelete = this.fileOperations.fileTree(destinationDir).matching(filesToDelete).getFiles();
        return StaleOutputCleaner.cleanOutputs(this.deleter, toDelete, destinationDir);
    }

    protected void processClasspathChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        ClasspathEntryChangeProcessor classpathEntryChangeProcessor = new ClasspathEntryChangeProcessor(current.getClasspathSnapshot(), previous);
        ClasspathSnapshot currentSnapshots = current.getClasspathSnapshot();
        Set<File> previousCompilationEntries = previous.getClasspath();
        Set<File> currentCompilationEntries = currentSnapshots.getEntries();
        List<Alignment<File>> alignment = Alignment.align(currentCompilationEntries.toArray(new File[0]), previousCompilationEntries.toArray(new File[0]));
        for (Alignment<File> fileAlignment : alignment) {
            switch (fileAlignment.getKind()) {
                case added: {
                    DefaultFileChange added = DefaultFileChange.added(fileAlignment.getCurrentValue().getAbsolutePath(), "classpathEntry", FileType.RegularFile, "");
                    classpathEntryChangeProcessor.processChange(added, spec);
                    break;
                }
                case removed: {
                    DefaultFileChange removed = DefaultFileChange.removed(fileAlignment.getPreviousValue().getAbsolutePath(), "classpathEntry", FileType.RegularFile, "");
                    classpathEntryChangeProcessor.processChange(removed, spec);
                    break;
                }
                case transformed: {
                    spec.setFullRebuildCause("Classpath has been changed", null);
                    return;
                }
                case identical: {
                    File key = fileAlignment.getPreviousValue();
                    ClasspathEntrySnapshot previousSnapshot = previous.getClasspathEntrySnapshot(key);
                    ClasspathEntrySnapshot snapshot = currentSnapshots.getSnapshot(key);
                    if (previousSnapshot != null && snapshot.getHash().equals(previousSnapshot.getHash())) break;
                    DefaultFileChange modified = DefaultFileChange.modified(key.getAbsolutePath(), "classpathEntry", FileType.RegularFile, FileType.RegularFile, "");
                    classpathEntryChangeProcessor.processChange(modified, spec);
                }
            }
        }
    }

    protected void addClassesToProcess(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        HashSet classesToProcess = Sets.newHashSet(recompilationSpec.getClassesToProcess());
        classesToProcess.removeAll(recompilationSpec.getClassesToCompile());
        spec.setClasses(classesToProcess);
    }

    protected void includePreviousCompilationOutputOnClasspath(JavaCompileSpec spec) {
        ArrayList classpath = Lists.newArrayList(spec.getCompileClasspath());
        File destinationDir = spec.getDestinationDir();
        classpath.add(destinationDir);
        spec.setCompileClasspath(classpath);
    }

    protected String rebuildClauseForChangedNonSourceFile(String description, FileChange fileChange) {
        return String.format("%s '%s' has been %s", description, fileChange.getFile().getName(), fileChange.getChangeType().name().toLowerCase(Locale.US));
    }
}

