/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.com.google.common.io.LineProcessor;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

public class SourceClassesMappingFileAccessor {
    private static final int BUFFER_SIZE = 65536;

    public static Multimap<String, String> readSourceClassesMappingFile(File mappingFile) {
        SetMultimap sourceClassesMapping = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
        if (!mappingFile.isFile()) {
            return sourceClassesMapping;
        }
        try {
            Files.asCharSource((File)mappingFile, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Void>((Multimap)sourceClassesMapping){
                private String currentFile;
                final /* synthetic */ Multimap val$sourceClassesMapping;
                {
                    this.val$sourceClassesMapping = multimap;
                }

                public boolean processLine(String line) throws IOException {
                    if (line.startsWith(" ")) {
                        this.val$sourceClassesMapping.put((Object)this.currentFile, (Object)line.substring(1));
                    } else {
                        this.currentFile = line;
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return sourceClassesMapping;
    }

    public static void writeSourceClassesMappingFile(File mappingFile, Map<String, Collection<String>> mapping) {
        try (BufferedWriter wrt = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mappingFile, false), StandardCharsets.UTF_8), 65536);){
            for (Map.Entry<String, Collection<String>> entry : mapping.entrySet()) {
                wrt.write(entry.getKey() + "\n");
                for (String className : entry.getValue()) {
                    wrt.write(" " + className + "\n");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeSourceClassesMappingFile(File mappingFile, Multimap<String, String> mapping) {
        SourceClassesMappingFileAccessor.writeSourceClassesMappingFile(mappingFile, mapping.asMap());
    }

    public static void mergeIncrementalMappingsIntoOldMappings(File sourceClassesMappingFile, FileCollection stableSources, InputChanges inputChanges, Multimap<String, String> oldMappings) {
        Multimap<String, String> mappingsDuringIncrementalCompilation = SourceClassesMappingFileAccessor.readSourceClassesMappingFile(sourceClassesMappingFile);
        StreamSupport.stream(inputChanges.getFileChanges(stableSources).spliterator(), false).filter(fileChange -> fileChange.getChangeType() == ChangeType.REMOVED).map(FileChange::getNormalizedPath).forEach(arg_0 -> oldMappings.removeAll(arg_0));
        mappingsDuringIncrementalCompilation.keySet().forEach(arg_0 -> oldMappings.removeAll(arg_0));
        oldMappings.putAll(mappingsDuringIncrementalCompilation);
        SourceClassesMappingFileAccessor.writeSourceClassesMappingFile(sourceClassesMappingFile, oldMappings);
    }
}

