/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.util.NameValidator;

public class TaskFactory
implements ITaskFactory {
    private final ProjectInternal project;
    private final InstantiationScheme instantiationScheme;

    public TaskFactory() {
        this(null, null);
    }

    private TaskFactory(ProjectInternal project, InstantiationScheme instantiationScheme) {
        this.project = project;
        this.instantiationScheme = instantiationScheme;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, InstantiationScheme instantiationScheme) {
        return new TaskFactory(project, instantiationScheme);
    }

    @Override
    public <S extends Task> S create(final TaskIdentity<S> identity, final @Nullable Object[] constructorArgs) {
        Class implType;
        if (!Task.class.isAssignableFrom(identity.type)) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not implement the Task interface.", identity.type.getSimpleName()));
        }
        NameValidator.validate(identity.name, "task name", "");
        if (identity.type == Task.class) {
            implType = DefaultTask.class;
        } else if (DefaultTask.class.isAssignableFrom(identity.type)) {
            implType = identity.type.asSubclass(AbstractTask.class);
        } else if (identity.type == AbstractTask.class || identity.type == TaskInternal.class) {
            DeprecationLogger.deprecate("Registering a task with type " + identity.type.getSimpleName()).willBecomeAnErrorInGradle7().withUpgradeGuideSection(6, "abstract_task_deprecated").nagUser();
            implType = DefaultTask.class;
        } else {
            DeprecationLogger.deprecate("Registering a task with a type that directly extends AbstractTask").willBecomeAnErrorInGradle7().withUpgradeGuideSection(6, "abstract_task_deprecated").nagUser();
            implType = identity.type.asSubclass(AbstractTask.class);
        }
        final DisplayName displayName = Describables.withTypeAndName("task", identity.getIdentityPath());
        return AbstractTask.injectIntoNewInstance(this.project, identity, new Callable<S>(){

            @Override
            public S call() {
                try {
                    Task instance = constructorArgs != null ? (Task)TaskFactory.this.instantiationScheme.instantiator().newInstanceWithDisplayName(implType, displayName, constructorArgs) : (Task)TaskFactory.this.instantiationScheme.deserializationInstantiator().newInstance(implType, AbstractTask.class);
                    return (Task)identity.type.cast(instance);
                }
                catch (ObjectInstantiationException e) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", identity.type.getSimpleName()), e.getCause());
                }
            }
        });
    }
}

