/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.DefaultMutationGuard;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.WithMutationGuard;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class BuildOperationCrossProjectConfigurator
implements CrossProjectConfigurator,
WithMutationGuard {
    private final BuildOperationExecutor buildOperationExecutor;
    private final MutationGuard mutationGuard = new DefaultMutationGuard();

    public BuildOperationCrossProjectConfigurator(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Project project(Project project, Action<? super Project> configureAction) {
        this.runProjectConfigureAction(project, configureAction);
        return project;
    }

    @Override
    public void subprojects(Iterable<Project> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(BlockConfigureBuildOperation.SUBPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public void allprojects(Iterable<Project> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(BlockConfigureBuildOperation.ALLPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public Project rootProject(Project project, Action<Project> buildOperationExecutor) {
        this.runBlockConfigureAction(BlockConfigureBuildOperation.ROOT_PROJECT_DETAILS, Collections.singleton(project), buildOperationExecutor);
        return project;
    }

    private void runBlockConfigureAction(BuildOperationDescriptor.Builder details, Iterable<Project> projects, final Action<? super Project> configureAction) {
        this.buildOperationExecutor.run(new BlockConfigureBuildOperation(details, projects){

            @Override
            protected void doRunProjectConfigure(Project project) {
                BuildOperationCrossProjectConfigurator.this.runProjectConfigureAction(project, configureAction);
            }
        });
    }

    private void runProjectConfigureAction(final Project project, final Action<? super Project> configureAction) {
        ((ProjectInternal)project).getMutationState().withMutableState(new Runnable(){

            @Override
            public void run() {
                BuildOperationCrossProjectConfigurator.this.buildOperationExecutor.run(new CrossConfigureProjectBuildOperation(project){

                    @Override
                    public void run(BuildOperationContext context) {
                        Actions.with(project, BuildOperationCrossProjectConfigurator.this.mutationGuard.withMutationEnabled(configureAction));
                    }
                });
            }
        });
    }

    @Override
    public MutationGuard getMutationGuard() {
        return this.mutationGuard;
    }

    private static abstract class CrossConfigureProjectBuildOperation
    implements RunnableBuildOperation {
        private Project project;

        private CrossConfigureProjectBuildOperation(Project project) {
            this.project = project;
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            String name = "Cross-configure project " + ((ProjectInternal)this.project).getIdentityPath().toString();
            return BuildOperationDescriptor.displayName(name);
        }
    }

    private static abstract class BlockConfigureBuildOperation
    implements RunnableBuildOperation {
        private static final String ALLPROJECTS = "allprojects";
        private static final String SUBPROJECTS = "subprojects";
        private static final String ROOTPROJECT = "rootProject";
        private static final BuildOperationDescriptor.Builder ALLPROJECTS_DETAILS = BlockConfigureBuildOperation.computeConfigurationBlockBuildOperationDetails("allprojects");
        private static final BuildOperationDescriptor.Builder SUBPROJECTS_DETAILS = BlockConfigureBuildOperation.computeConfigurationBlockBuildOperationDetails("subprojects");
        private static final BuildOperationDescriptor.Builder ROOT_PROJECT_DETAILS = BlockConfigureBuildOperation.computeConfigurationBlockBuildOperationDetails("rootProject");
        private final BuildOperationDescriptor.Builder details;
        private final Iterable<Project> projects;

        private BlockConfigureBuildOperation(BuildOperationDescriptor.Builder details, Iterable<Project> projects) {
            this.details = details;
            this.projects = projects;
        }

        private static BuildOperationDescriptor.Builder computeConfigurationBlockBuildOperationDetails(String configurationBlockName) {
            return BuildOperationDescriptor.displayName("Execute '" + configurationBlockName + " {}' action").name(configurationBlockName);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return this.details;
        }

        @Override
        public void run(BuildOperationContext context) {
            for (Project project : this.projects) {
                this.doRunProjectConfigure(project);
            }
        }

        abstract void doRunProjectConfigure(Project var1);
    }
}

