/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.gradle.api.internal.file.archive.compression.CompressedReadableResource;
import org.gradle.api.internal.file.archive.compression.URIBuilder;
import org.gradle.api.resources.internal.ReadableResourceInternal;

abstract class AbstractArchiver
implements CompressedReadableResource {
    protected final ReadableResourceInternal resource;
    protected final URI uri;

    public AbstractArchiver(ReadableResourceInternal resource) {
        assert (resource != null);
        this.uri = new URIBuilder(resource.getURI()).schemePrefix(this.getSchemePrefix()).build();
        this.resource = resource;
    }

    protected abstract String getSchemePrefix();

    @Override
    public abstract InputStream read();

    @Override
    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getBaseName() {
        return this.resource.getBaseName();
    }

    @Override
    public File getBackingFile() {
        return this.resource.getBackingFile();
    }
}

