/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.ManagedFactories;
import org.gradle.api.internal.provider.AbstractCombiningProvider;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.MappingProvider;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.state.Managed;

public class DefaultFilePropertyFactory
implements FilePropertyFactory,
FileFactory {
    private final PropertyHost host;
    private final FileResolver fileResolver;
    private final FileCollectionFactory fileCollectionFactory;

    public DefaultFilePropertyFactory(PropertyHost host, FileResolver resolver, FileCollectionFactory fileCollectionFactory) {
        this.host = host;
        this.fileResolver = resolver;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public DirectoryProperty newDirectoryProperty() {
        return new DefaultDirectoryVar(this.host, this.fileResolver, this.fileCollectionFactory);
    }

    @Override
    public RegularFileProperty newFileProperty() {
        return new DefaultRegularFileVar(this.host, this.fileResolver);
    }

    @Override
    public Directory dir(File dir) {
        dir = this.fileResolver.resolve(dir);
        return new FixedDirectory(dir, this.fileResolver.newResolver(dir), this.fileCollectionFactory);
    }

    @Override
    public RegularFile file(File file) {
        file = this.fileResolver.resolve(file);
        return new FixedFile(file);
    }

    private static class ToFileTransformer
    implements Transformer<File, FileSystemLocation> {
        private ToFileTransformer() {
        }

        @Override
        public File transform(FileSystemLocation location) {
            return location.getAsFile();
        }
    }

    private static class PathToDirectoryTransformer
    implements Transformer<Directory, Directory> {
        private final String path;

        public PathToDirectoryTransformer(String path) {
            this.path = path;
        }

        @Override
        public Directory transform(Directory directory) {
            return directory.dir(this.path);
        }
    }

    private static class PathToFileTransformer
    implements Transformer<RegularFile, Directory> {
        private final String path;

        public PathToFileTransformer(String path) {
            this.path = path;
        }

        @Override
        public RegularFile transform(Directory directory) {
            return directory.file(this.path);
        }
    }

    public static class DefaultDirectoryVar
    extends AbstractFileVar<Directory, DirectoryProperty>
    implements DirectoryProperty,
    Managed {
        private final FileResolver resolver;
        private final FileCollectionFactory fileCollectionFactory;

        DefaultDirectoryVar(PropertyHost host, FileResolver resolver, FileCollectionFactory fileCollectionFactory) {
            super(host, Directory.class);
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        @Override
        public Class<?> publicType() {
            return DirectoryProperty.class;
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.DirectoryPropertyManagedFactory.FACTORY_ID;
        }

        @Override
        public FileTree getAsFileTree() {
            return this.fileCollectionFactory.resolving(this).getAsFileTree();
        }

        @Override
        protected Directory fromFile(File dir) {
            File resolved = this.resolver.resolve(dir);
            FileResolver dirResolver = this.resolver.newResolver(resolved);
            return new FixedDirectory(resolved, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }

        @Override
        public Provider<Directory> dir(String path) {
            return new MappingProvider<Directory, Directory>(Directory.class, this, new PathToDirectoryTransformer(path));
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<Directory, Directory, CharSequence>(Directory.class, (ProviderInternal)this, Providers.internal(path)){

                @Override
                protected Directory map(Directory b, CharSequence v) {
                    return b.dir(v.toString());
                }
            };
        }

        @Override
        public Provider<RegularFile> file(String path) {
            return new MappingProvider<RegularFile, Directory>(RegularFile.class, this, new PathToFileTransformer(path));
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<RegularFile, Directory, CharSequence>(RegularFile.class, (ProviderInternal)this, Providers.internal(path)){

                @Override
                protected RegularFile map(Directory b, CharSequence v) {
                    return b.file(v.toString());
                }
            };
        }

        @Override
        public FileCollection files(Object ... paths) {
            return this.fileCollectionFactory.withResolver(this.resolver).resolving(paths);
        }
    }

    private static class ResolvingDirectoryTransformer
    implements Transformer<Directory, CharSequence> {
        private final FileResolver resolver;
        private final FileCollectionFactory fileCollectionFactory;

        ResolvingDirectoryTransformer(FileResolver resolver, FileCollectionFactory fileCollectionFactory) {
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        @Override
        public Directory transform(CharSequence path) {
            File dir = this.resolver.resolve(path);
            FileResolver dirResolver = this.resolver.newResolver(dir);
            return new FixedDirectory(dir, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }
    }

    public static class DefaultRegularFileVar
    extends AbstractFileVar<RegularFile, RegularFileProperty>
    implements RegularFileProperty,
    Managed {
        private final PathToFileResolver fileResolver;

        DefaultRegularFileVar(PropertyHost host, PathToFileResolver fileResolver) {
            super(host, RegularFile.class);
            this.fileResolver = fileResolver;
        }

        @Override
        public Class<?> publicType() {
            return RegularFileProperty.class;
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.RegularFilePropertyManagedFactory.FACTORY_ID;
        }

        @Override
        protected RegularFile fromFile(File file) {
            return new FixedFile(this.fileResolver.resolve(file));
        }
    }

    private static abstract class AbstractFileVar<T extends FileSystemLocation, THIS extends FileSystemLocationProperty<T>>
    extends DefaultProperty<T>
    implements FileSystemLocationProperty<T> {
        public AbstractFileVar(PropertyHost host, Class<T> type) {
            super(host, type);
        }

        protected abstract T fromFile(File var1);

        @Override
        public Provider<File> getAsFile() {
            return new MappingProvider<File, FileSystemLocation>(File.class, this, new ToFileTransformer());
        }

        @Override
        public void setFromAnyValue(Object object) {
            if (object instanceof File) {
                this.set((File)object);
            } else {
                super.setFromAnyValue(object);
            }
        }

        public THIS value(T value) {
            super.value(value);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS value(Provider<? extends T> provider) {
            super.value(provider);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        @Override
        public void set(File file) {
            if (file == null) {
                this.set((FileSystemLocation)null);
                return;
            }
            this.set(this.fromFile(file));
        }

        public THIS fileValue(@Nullable File file) {
            this.set(file);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS fileProvider(Provider<File> provider) {
            this.set(provider.map(new Transformer<T, File>(){

                @Override
                public T transform(File file) {
                    return this.fromFile(file);
                }
            }));
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS convention(T value) {
            super.convention(value);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS convention(Provider<? extends T> valueProvider) {
            super.convention(valueProvider);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        @Override
        public Provider<T> getLocationOnly() {
            return new AbstractMinimalProvider<T>(){

                @Override
                @Nullable
                public Class<T> getType() {
                    return this.getType();
                }

                @Override
                protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
                    return this.calculateOwnValueNoProducer(consumer);
                }
            };
        }
    }

    private static class ResolvingRegularFileTransform
    implements Transformer<RegularFile, CharSequence> {
        private final PathToFileResolver resolver;

        ResolvingRegularFileTransform(PathToFileResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public RegularFile transform(CharSequence path) {
            return new FixedFile(this.resolver.resolve(path));
        }
    }

    private static class FixedFile
    extends DefaultFileSystemLocation
    implements RegularFile,
    Managed {
        FixedFile(File file) {
            super(file);
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public Class<?> publicType() {
            return RegularFile.class;
        }

        @Override
        public Object unpackState() {
            return this.getAsFile();
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.RegularFileManagedFactory.FACTORY_ID;
        }
    }

    private static class FixedDirectory
    extends DefaultFileSystemLocation
    implements Directory,
    Managed {
        final FileResolver fileResolver;
        private final FileCollectionFactory fileCollectionFactory;

        FixedDirectory(File value, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory) {
            super(value);
            this.fileResolver = fileResolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public Class<?> publicType() {
            return Directory.class;
        }

        @Override
        public Object unpackState() {
            return this.getAsFile();
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.DirectoryManagedFactory.FACTORY_ID;
        }

        @Override
        public Directory dir(String path) {
            File newDir = this.fileResolver.resolve(path);
            FileResolver dirResolver = this.fileResolver.newResolver(newDir);
            return new FixedDirectory(newDir, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }

        @Override
        public FileTree getAsFileTree() {
            return this.fileCollectionFactory.resolving(this).getAsFileTree();
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new MappingProvider<Directory, CharSequence>(Directory.class, Providers.internal(path), new ResolvingDirectoryTransformer(this.fileResolver, this.fileCollectionFactory));
        }

        @Override
        public RegularFile file(String path) {
            return new FixedFile(this.fileResolver.resolve(path));
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new MappingProvider<RegularFile, CharSequence>(RegularFile.class, Providers.internal(path), new ResolvingRegularFileTransform(this.fileResolver));
        }

        @Override
        public FileCollection files(Object ... paths) {
            return this.fileCollectionFactory.withResolver(this.fileResolver).resolving(paths);
        }
    }
}

