/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.properties.LifecycleAwareValue;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class CachingTaskInputFileCollection
extends DefaultConfigurableFileCollection
implements LifecycleAwareValue {
    private boolean canCache;
    private MinimalFileSet cachedValue;

    public CachingTaskInputFileCollection(PathToFileResolver fileResolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost) {
        super(null, fileResolver, taskDependencyFactory, patternSetFactory, propertyHost);
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        if (this.canCache) {
            if (this.cachedValue == null) {
                DefaultFileCollectionResolveContext nested = new DefaultFileCollectionResolveContext(this.patternSetFactory);
                super.visitContents(nested);
                ImmutableSet.Builder files = ImmutableSet.builder();
                for (FileCollectionInternal fileCollection : nested.resolveAsFileCollections()) {
                    files.addAll((Iterable)fileCollection);
                }
                this.cachedValue = new ListBackedFileSet((Collection<File>)files.build());
            }
            context.add(this.cachedValue);
        } else {
            super.visitContents(context);
        }
    }

    @Override
    public void prepareValue() {
        this.canCache = true;
    }

    @Override
    public void cleanupValue() {
        this.canCache = false;
        this.cachedValue = null;
    }
}

