/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifier;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifierBuilder;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentFileArtifactIdentifier;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Interners;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DependencyVerificationsXmlReader {
    public static void readFromXml(InputStream in, DependencyVerifierBuilder builder) {
        try {
            SAXParser saxParser = DependencyVerificationsXmlReader.createSecureParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            VerifiersHandler handler = new VerifiersHandler(builder);
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Unable to read dependency verification metadata", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    public static DependencyVerifier readFromXml(InputStream in) {
        DependencyVerifierBuilder builder = new DependencyVerifierBuilder();
        DependencyVerificationsXmlReader.readFromXml(in, builder);
        return builder.build();
    }

    private static SAXParser createSecureParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://xml.org/sax/features/namespaces", false);
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return spf.newSAXParser();
    }

    private static class VerifiersHandler
    extends DefaultHandler {
        private final Interner<String> stringInterner = Interners.newStrongInterner();
        private final DependencyVerifierBuilder builder;
        private boolean inMetadata;
        private boolean inComponents;
        private boolean inConfiguration;
        private boolean inVerifyMetadata;
        private boolean inVerifySignatures;
        private boolean inTrustedArtifacts;
        private boolean inKeyServers;
        private boolean inIgnoredKeys;
        private boolean inTrustedKeys;
        private boolean inTrustedKey;
        private String currentTrustedKey;
        private ModuleComponentIdentifier currentComponent;
        private ModuleComponentArtifactIdentifier currentArtifact;
        private ChecksumKind currentChecksum;

        public VerifiersHandler(DependencyVerifierBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (qName) {
                case "configuration": {
                    this.inConfiguration = true;
                    break;
                }
                case "verification-metadata": {
                    this.inMetadata = true;
                    break;
                }
                case "components": {
                    this.assertInMetadata();
                    this.inComponents = true;
                    break;
                }
                case "component": {
                    this.assertInComponents();
                    this.currentComponent = this.createComponentId(attributes);
                    break;
                }
                case "artifact": {
                    this.assertValidComponent();
                    this.currentArtifact = this.createArtifactId(attributes);
                    break;
                }
                case "verify-metadata": {
                    this.assertInConfiguration("verify-metadata");
                    this.inVerifyMetadata = true;
                    break;
                }
                case "verify-signatures": {
                    this.assertInConfiguration("verify-signatures");
                    this.inVerifySignatures = true;
                    break;
                }
                case "trusted-artifacts": {
                    this.assertInConfiguration("trusted-artifacts");
                    this.inTrustedArtifacts = true;
                    break;
                }
                case "trusted-key": {
                    VerifiersHandler.assertContext(this.inTrustedKeys, "trusted-key", "trusted-keys");
                    this.addTrustedKey(attributes);
                    this.inTrustedKey = true;
                    break;
                }
                case "trusted-keys": {
                    this.assertInConfiguration("trusted-keys");
                    this.inTrustedKeys = true;
                    break;
                }
                case "trust": {
                    this.assertInTrustedArtifacts();
                    this.addTrustedArtifact(attributes);
                    break;
                }
                case "trusting": {
                    VerifiersHandler.assertContext(this.inTrustedKey, "trusting", "trusted-key");
                    this.maybeAddTrustedKey(attributes);
                    break;
                }
                case "key-servers": {
                    this.assertInConfiguration("key-servers");
                    this.inKeyServers = true;
                    break;
                }
                case "key-server": {
                    VerifiersHandler.assertContext(this.inKeyServers, "key-server", "key-servers");
                    String server = this.getAttribute(attributes, "uri");
                    try {
                        this.builder.addKeyServer(new URI(server));
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new InvalidUserDataException("Unsupported URI for key server: " + server);
                    }
                }
                case "ignored-keys": {
                    if (this.currentArtifact == null) {
                        this.assertInConfiguration("ignored-keys");
                    }
                    this.inIgnoredKeys = true;
                    break;
                }
                case "ignored-key": {
                    VerifiersHandler.assertContext(this.inIgnoredKeys, "ignored-key", "ignored-keys");
                    if (this.currentArtifact != null) {
                        this.addArtifactIgnoredKey(attributes);
                        break;
                    }
                    this.addIgnoredKey(attributes);
                    break;
                }
                default: {
                    if (this.currentChecksum != null && "also-trust".equals(qName)) {
                        this.builder.addChecksum(this.currentArtifact, this.currentChecksum, this.getAttribute(attributes, "value"), null);
                        break;
                    }
                    if (this.currentArtifact == null) break;
                    if ("pgp".equals(qName)) {
                        this.builder.addTrustedKey(this.currentArtifact, this.getAttribute(attributes, "value"));
                        break;
                    }
                    this.currentChecksum = ChecksumKind.valueOf(qName);
                    this.builder.addChecksum(this.currentArtifact, this.currentChecksum, this.getAttribute(attributes, "value"), this.getNullableAttribute(attributes, "origin"));
                }
            }
        }

        private void addArtifactIgnoredKey(Attributes attributes) {
            this.builder.addIgnoredKey(this.currentArtifact, this.toIgnoredKey(attributes));
        }

        private IgnoredKey toIgnoredKey(Attributes attributes) {
            return new IgnoredKey(this.getAttribute(attributes, "id"), this.getNullableAttribute(attributes, "reason"));
        }

        private void addIgnoredKey(Attributes attributes) {
            this.builder.addIgnoredKey(this.toIgnoredKey(attributes));
        }

        private void assertInTrustedArtifacts() {
            VerifiersHandler.assertContext(this.inTrustedArtifacts, "trust", "trusted-artifacts");
        }

        private void addTrustedArtifact(Attributes attributes) {
            boolean regex = false;
            String regexAttr = this.getNullableAttribute(attributes, "regex");
            if (regexAttr != null) {
                regex = Boolean.parseBoolean(regexAttr);
            }
            this.builder.addTrustedArtifact(this.getNullableAttribute(attributes, "group"), this.getNullableAttribute(attributes, "name"), this.getNullableAttribute(attributes, "version"), this.getNullableAttribute(attributes, "file"), regex);
        }

        private void addTrustedKey(Attributes attributes) {
            this.currentTrustedKey = this.getAttribute(attributes, "id");
            this.maybeAddTrustedKey(attributes);
        }

        private void maybeAddTrustedKey(Attributes attributes) {
            boolean regex = false;
            String regexAttr = this.getNullableAttribute(attributes, "regex");
            if (regexAttr != null) {
                regex = Boolean.parseBoolean(regexAttr);
            }
            String group = this.getNullableAttribute(attributes, "group");
            String name = this.getNullableAttribute(attributes, "name");
            String version = this.getNullableAttribute(attributes, "version");
            String file = this.getNullableAttribute(attributes, "file");
            if (group != null || name != null || version != null || file != null) {
                this.builder.addTrustedKey(this.currentTrustedKey, group, name, version, file, regex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.inVerifyMetadata) {
                this.builder.setVerifyMetadata(this.readBoolean(ch, start, length));
            } else if (this.inVerifySignatures) {
                this.builder.setVerifySignatures(this.readBoolean(ch, start, length));
            }
        }

        private boolean readBoolean(char[] ch, int start, int length) {
            return Boolean.parseBoolean(new String(ch, start, length));
        }

        private void assertInConfiguration(String tag) {
            VerifiersHandler.assertContext(this.inConfiguration, tag, "configuration");
        }

        private void assertInComponents() {
            VerifiersHandler.assertContext(this.inComponents, "component", "components");
        }

        private void assertInMetadata() {
            VerifiersHandler.assertContext(this.inMetadata, "components", "verification-metadata");
        }

        private void assertValidComponent() {
            VerifiersHandler.assertContext(this.currentComponent != null, "artifact", "component");
        }

        private static void assertContext(boolean test, String innerTag, String outerTag) {
            VerifiersHandler.assertContext(test, "<" + innerTag + "> must be found under the <" + outerTag + "> tag");
        }

        private static void assertContext(boolean test, String message) {
            if (!test) {
                throw new InvalidUserDataException("Invalid dependency verification metadata file: " + message);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (qName) {
                case "configuration": {
                    this.inConfiguration = false;
                    break;
                }
                case "verify-metadata": {
                    this.inVerifyMetadata = false;
                    break;
                }
                case "verify-signatures": {
                    this.inVerifySignatures = false;
                    break;
                }
                case "verification-metadata": {
                    this.inMetadata = false;
                    break;
                }
                case "components": {
                    this.inComponents = false;
                    break;
                }
                case "component": {
                    this.currentComponent = null;
                    break;
                }
                case "trusted-artifacts": {
                    this.inTrustedArtifacts = false;
                    break;
                }
                case "trusted-keys": {
                    this.inTrustedKeys = false;
                    break;
                }
                case "trusted-key": {
                    this.inTrustedKey = false;
                    this.currentTrustedKey = null;
                    break;
                }
                case "key-servers": {
                    this.inKeyServers = false;
                    break;
                }
                case "artifact": {
                    this.currentArtifact = null;
                    this.currentChecksum = null;
                    break;
                }
                case "ignored-keys": {
                    this.inIgnoredKeys = false;
                }
            }
        }

        private ModuleComponentFileArtifactIdentifier createArtifactId(Attributes attributes) {
            return new ModuleComponentFileArtifactIdentifier(this.currentComponent, this.getAttribute(attributes, "name"));
        }

        private ModuleComponentIdentifier createComponentId(Attributes attributes) {
            return DefaultModuleComponentIdentifier.newId(this.createModuleId(attributes), this.getAttribute(attributes, "version"));
        }

        private ModuleIdentifier createModuleId(Attributes attributes) {
            return DefaultModuleIdentifier.newId(this.getAttribute(attributes, "group"), this.getAttribute(attributes, "name"));
        }

        private String getAttribute(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            VerifiersHandler.assertContext(value != null, "Missing attribute: " + name);
            return (String)this.stringInterner.intern((Object)value);
        }

        private String getNullableAttribute(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            if (value == null) {
                return null;
            }
            return (String)this.stringInterner.intern((Object)value);
        }
    }
}

