/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public final class GrFileIndexUtil {
    public static boolean isGroovySourceFile(@NotNull PsiFile file) {
        return file instanceof GroovyFileBase && GrFileIndexUtil.isGroovySourceFile((GroovyFileBase)file);
    }

    public static boolean isGroovySourceFile(@NotNull GroovyFileBase file) {
        return GrFileIndexUtil.isInSourceFiles(file.getVirtualFile(), file.getProject());
    }

    private static boolean isInSourceFiles(@Nullable VirtualFile file, @NotNull Project project) {
        FileIndexFacade index;
        return file != null && !(file instanceof LightVirtualFile) && ((index = FileIndexFacade.getInstance((Project)project)).isInSource(file) || index.isInLibraryClasses(file));
    }
}

