/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.template.expressions;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class ChooseTypeExpression
extends Expression {
    public static final InsertHandler<PsiTypeLookupItem> IMPORT_FIXER = new InsertHandler<PsiTypeLookupItem>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull PsiTypeLookupItem item) {
            GroovyCompletionUtil.addImportForItem(context.getFile(), context.getStartOffset(), (LookupElement)item);
        }
    };
    protected final SmartTypePointer myTypePointer;
    private final List<SmartTypePointer> myItems;
    private final boolean myAddDefType;
    private final boolean mySelectDef;

    public ChooseTypeExpression(TypeConstraint @NotNull [] constraints, PsiManager manager, GlobalSearchScope resolveScope) {
        this(constraints, manager, resolveScope, true);
    }

    public ChooseTypeExpression(TypeConstraint[] constraints, PsiManager manager, GlobalSearchScope resolveScope, boolean addDefType) {
        this(constraints, manager, resolveScope, addDefType, false);
    }

    public ChooseTypeExpression(TypeConstraint[] constraints, PsiManager manager, GlobalSearchScope resolveScope, boolean addDefType, boolean selectDef) {
        this.myAddDefType = addDefType;
        SmartTypePointerManager typePointerManager = SmartTypePointerManager.getInstance((Project)manager.getProject());
        this.myTypePointer = typePointerManager.createSmartTypePointer(ChooseTypeExpression.chooseType(constraints, resolveScope, manager));
        this.myItems = ChooseTypeExpression.createItems(constraints, typePointerManager);
        this.mySelectDef = selectDef;
    }

    @NotNull
    private static List<SmartTypePointer> createItems(TypeConstraint @NotNull [] constraints, @NotNull SmartTypePointerManager typePointerManager) {
        ArrayList<SmartTypePointer> result2 = new ArrayList<SmartTypePointer>();
        for (TypeConstraint constraint : constraints) {
            if (constraint instanceof SubtypeConstraint) {
                PsiType type2 = constraint.getDefaultType();
                result2.add(typePointerManager.createSmartTypePointer(type2));
                continue;
            }
            if (!(constraint instanceof SupertypeConstraint)) continue;
            ChooseTypeExpression.processSuperTypes(constraint.getType(), result2, typePointerManager);
        }
        return result2;
    }

    private static void processSuperTypes(@NotNull PsiType type2, @NotNull List<SmartTypePointer> result2, @NotNull SmartTypePointerManager typePointerManager) {
        PsiType[] superTypes;
        result2.add(typePointerManager.createSmartTypePointer(type2));
        for (PsiType superType : superTypes = type2.getSuperTypes()) {
            ChooseTypeExpression.processSuperTypes(superType, result2, typePointerManager);
        }
    }

    @NotNull
    private static PsiType chooseType(TypeConstraint @NotNull [] constraints, @NotNull GlobalSearchScope scope, @NotNull PsiManager manager) {
        if (constraints.length > 0) {
            return constraints[0].getDefaultType();
        }
        return PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope);
    }

    public Result calculateResult(ExpressionContext context) {
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        PsiType type2 = this.myTypePointer.getType();
        if (type2 != null) {
            if (this.myAddDefType && (type2.equalsToText("java.lang.Object") || this.mySelectDef)) {
                return new TextResult("def");
            }
            if ((type2 = TypesUtil.unboxPrimitiveTypeWrapper(type2)) == null) {
                return null;
            }
            final PsiType finalType = type2;
            return new PsiTypeResult(finalType, context.getProject()){

                public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
                    if (ChooseTypeExpression.this.myItems.size() <= 1) {
                        super.handleRecalc(psiFile, document, segmentStart, segmentEnd);
                    } else {
                        JavaTemplateUtil.updateTypeBindings((Object)this.getType(), (PsiFile)psiFile, (Document)document, (int)segmentStart, (int)segmentEnd, (boolean)true);
                    }
                }

                public String toString() {
                    return ChooseTypeExpression.this.myItems.size() == 1 ? super.toString() : finalType.getPresentableText();
                }
            };
        }
        return null;
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (SmartTypePointer item : this.myItems) {
            PsiType type2 = TypesUtil.unboxPrimitiveTypeWrapper(item.getType());
            if (type2 == null) continue;
            PsiTypeLookupItem lookupItem = PsiTypeLookupItem.createLookupItem((PsiType)type2, null, (boolean)PsiTypeLookupItem.isDiamond((PsiType)type2), IMPORT_FIXER);
            result2.add(lookupItem);
        }
        if (this.myAddDefType) {
            LookupElementBuilder def = LookupElementBuilder.create((String)"def").bold();
            if (this.mySelectDef) {
                result2.add(0, def);
            } else {
                result2.add(def);
            }
        }
        return result2.toArray(LookupElement.EMPTY_ARRAY);
    }
}

