/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.shell.GroovyShellCodeFragment;

public class GroovyShellCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        GrExpression invokedExpression;
        PsiElement ppparent;
        PsiFile file = parameters2.getOriginalFile();
        if (!(file instanceof GroovyShellCodeFragment)) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        PsiElement parent2 = position.getParent();
        if (!(parent2 instanceof GrReferenceExpression) || ((GrReferenceExpression)parent2).isQualified()) {
            return;
        }
        if (PsiUtil.isExpressionStatement(parent2)) {
            GroovyShellCompletionContributor.addAllCommands(result2);
        } else if (parent2.getParent() instanceof GrCommandArgumentList && (ppparent = parent2.getParent().getParent()) instanceof GrMethodCall && GroovyShellCompletionContributor.isFirstArg((GrMethodCall)ppparent, parent2) && (invokedExpression = ((GrMethodCall)ppparent).getInvokedExpression()) instanceof GrReferenceExpression && !((GrReferenceExpression)invokedExpression).isQualified()) {
            String name = ((GrReferenceExpression)invokedExpression).getReferenceName();
            if ("help".equals(name)) {
                GroovyShellCompletionContributor.addAllCommands(result2);
            } else if ("show".equals(name)) {
                GroovyShellCompletionContributor.add(result2, "classes");
                GroovyShellCompletionContributor.add(result2, "imports");
                GroovyShellCompletionContributor.add(result2, "preferences");
                GroovyShellCompletionContributor.add(result2, "all");
            } else if ("purge".equals(name)) {
                GroovyShellCompletionContributor.add(result2, "variables");
                GroovyShellCompletionContributor.add(result2, "classes");
                GroovyShellCompletionContributor.add(result2, "imports");
                GroovyShellCompletionContributor.add(result2, "preferences");
                GroovyShellCompletionContributor.add(result2, "all");
            } else if ("record".equals(name)) {
                GroovyShellCompletionContributor.add(result2, "start");
                GroovyShellCompletionContributor.add(result2, "stop");
                GroovyShellCompletionContributor.add(result2, "status");
            } else if ("history".equals(name)) {
                GroovyShellCompletionContributor.add(result2, "show");
                GroovyShellCompletionContributor.add(result2, "recall");
                GroovyShellCompletionContributor.add(result2, "flush");
                GroovyShellCompletionContributor.add(result2, "clear");
            }
        }
    }

    private static void add(@NotNull CompletionResultSet result2, @NotNull String name) {
        result2.addElement((LookupElement)LookupElementBuilder.create((String)name));
    }

    private static void addAllCommands(@NotNull CompletionResultSet result2) {
        GroovyShellCompletionContributor.add(result2, "help");
        GroovyShellCompletionContributor.add(result2, "exit");
        GroovyShellCompletionContributor.add(result2, "quit");
        GroovyShellCompletionContributor.add(result2, "display");
        GroovyShellCompletionContributor.add(result2, "clear");
        GroovyShellCompletionContributor.add(result2, "show");
        GroovyShellCompletionContributor.add(result2, "inspect");
        GroovyShellCompletionContributor.add(result2, "purge");
        GroovyShellCompletionContributor.add(result2, "edit");
        GroovyShellCompletionContributor.add(result2, "load");
        GroovyShellCompletionContributor.add(result2, "save");
        GroovyShellCompletionContributor.add(result2, "record");
        GroovyShellCompletionContributor.add(result2, "history");
        GroovyShellCompletionContributor.add(result2, "alias");
        GroovyShellCompletionContributor.add(result2, "set");
    }

    private static boolean isFirstArg(@NotNull GrMethodCall ppparent, @NotNull PsiElement parent2) {
        GroovyPsiElement[] arguments2 = ppparent.getArgumentList().getAllArguments();
        return arguments2.length > 0 && arguments2[0] == parent2;
    }
}

