/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.FindClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.shell.GroovyShellConfig;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class DefaultGroovyShellRunner
extends GroovyShellConfig {
    private static final String[] REQUIRED_GROOVY_CLASSES = new String[]{"org.apache.commons.cli.CommandLineParser", "org.codehaus.groovy.tools.shell.Main", "org.fusesource.jansi.AnsiConsole"};

    @Override
    @NotNull
    public String getWorkingDirectory(@NotNull Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots[0].getPath();
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Module module) throws ExecutionException {
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "org.codehaus.groovy.tools.shell.Main", false, true);
        res.setWorkingDirectory(this.getWorkingDirectory(module));
        return res;
    }

    @Override
    public boolean canRun(@NotNull Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots.length > 0 && DefaultGroovyShellRunner.hasGroovyWithNeededJars(module);
    }

    @Override
    @NotNull
    public String getVersion(@NotNull Module module) {
        String homePath = LibrariesUtil.getGroovyHomePath(module);
        assert (homePath != null);
        String version = GroovyConfigUtils.getInstance().getSDKVersion(homePath);
        return version == "undefined" ? "" : "Groovy " + version;
    }

    public static boolean hasGroovyWithNeededJars(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (String className : REQUIRED_GROOVY_CLASSES) {
            if (facade.findClass(className, scope) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuitableModule(Module module) {
        return super.isSuitableModule(module) && DefaultGroovyShellRunner.hasGroovyWithNeededJars(module);
    }

    @Override
    public Collection<Module> getPossiblySuitableModules(Project project) {
        LinkedHashSet results = null;
        for (String className : REQUIRED_GROOVY_CLASSES) {
            Collection someModules = FindClassUtil.findModulesWithClass((Project)project, (String)className);
            if (results == null) {
                results = new LinkedHashSet(someModules);
            } else {
                results.retainAll(someModules);
            }
            if (!results.isEmpty()) continue;
            return ContainerUtil.emptyList();
        }
        return results;
    }

    @Override
    public String getTitle() {
        return "Groovy Shell";
    }
}

