/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyStaticTypeCheckVisitor;

public class TypeChecker
extends GroovyStaticTypeCheckVisitor {
    List<ProblemFix> toApply = new ArrayList<ProblemFix>();

    @Override
    protected void registerError(@NotNull PsiElement location, @NotNull String description, LocalQuickFix @Nullable [] fixes, @NotNull ProblemHighlightType highlightType) {
        if (highlightType == ProblemHighlightType.GENERIC_ERROR && fixes != null && fixes.length > 0) {
            InspectionManager manager = InspectionManager.getInstance((Project)location.getProject());
            ProblemDescriptor descriptor = manager.createProblemDescriptor(location, description, fixes, highlightType, fixes.length == 1, false);
            this.toApply.add(new ProblemFix(fixes[0], descriptor));
        }
    }

    public List<ProblemFix> getFixes() {
        return this.toApply;
    }

    int applyFixes() {
        for (ProblemFix fix : this.toApply) {
            fix.apply();
        }
        return this.toApply.size();
    }

    public static class ProblemFix {
        @NotNull
        LocalQuickFix fix;
        @NotNull
        ProblemDescriptor descriptor;

        ProblemFix(@NotNull LocalQuickFix fix, @NotNull ProblemDescriptor descriptor) {
            this.fix = fix;
            this.descriptor = descriptor;
        }

        @NotNull
        public LocalQuickFix getFix() {
            return this.fix;
        }

        @NotNull
        public ProblemDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void apply() {
            this.fix.applyFix(this.descriptor.getPsiElement().getProject(), (CommonProblemDescriptor)this.descriptor);
        }
    }
}

