/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.WatchedRootsProvider;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcWatchedRootProvider
implements WatchedRootsProvider {
    private final Project myProject;

    public MvcWatchedRootProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Set<String> getRootsToWatch() {
        return MvcWatchedRootProvider.getRootsToWatch(this.myProject);
    }

    @NotNull
    public static Set<String> getRootsToWatch(Project project) {
        if (!project.isInitialized()) {
            return Collections.emptySet();
        }
        HashSet<String> result2 = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            File globalPluginsDir;
            File sdkWorkDir;
            MvcFramework framework = MvcFramework.getInstance(module);
            if (framework == null) continue;
            if (result2 == null) {
                result2 = new HashSet<String>();
            }
            if ((sdkWorkDir = framework.getCommonPluginsDir(module)) != null) {
                result2.add(sdkWorkDir.getAbsolutePath());
            }
            if ((globalPluginsDir = framework.getGlobalPluginsDir(module)) == null) continue;
            result2.add(globalPluginsDir.getAbsolutePath());
        }
        return result2 == null ? Collections.emptySet() : result2;
    }
}

