/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.MvcWatchedRootProvider;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

@Service
public final class MvcModuleStructureSynchronizer
implements Disposable {
    private final Set<Pair<Object, SyncAction>> myOrders = new LinkedHashSet<Pair<Object, SyncAction>>();
    private final Project myProject;
    private Set<VirtualFile> myPluginRoots = Collections.emptySet();
    private boolean myOutOfModuleDirectoryCreatedActionAdded;
    public static boolean ourGrailsTestFlag;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    public MvcModuleStructureSynchronizer(@NotNull Project project) {
        this.myProject = project;
    }

    public void dispose() {
    }

    @NotNull
    public static MvcModuleStructureSynchronizer getInstance(@NotNull Project project) {
        return (MvcModuleStructureSynchronizer)project.getService(MvcModuleStructureSynchronizer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectOpened() {
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        synchronized (set) {
            Project project = this.myProject;
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.UpdateProjectStructure));
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.EnsureRunConfigurationExists));
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.UpgradeFramework));
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.CreateAppStructureIfNeeded));
        }
        this.scheduleRunActions();
        this.addListeners();
    }

    public SimpleModificationTracker getFileAndRootsModificationTracker() {
        return this.myModificationTracker;
    }

    private void addListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                Set set = MvcModuleStructureSynchronizer.this.myOrders;
                synchronized (set) {
                    Project project = MvcModuleStructureSynchronizer.this.myProject;
                    MvcModuleStructureSynchronizer.this.myOrders.add(new Pair((Object)project, (Object)SyncAction.SyncLibrariesInPluginsModule));
                    MvcModuleStructureSynchronizer.this.myOrders.add(new Pair((Object)project, (Object)SyncAction.UpgradeFramework));
                    MvcModuleStructureSynchronizer.this.myOrders.add(new Pair((Object)project, (Object)SyncAction.CreateAppStructureIfNeeded));
                    MvcModuleStructureSynchronizer.this.myOrders.add(new Pair((Object)project, (Object)SyncAction.UpdateProjectStructure));
                    MvcModuleStructureSynchronizer.this.myOrders.add(new Pair((Object)project, (Object)SyncAction.EnsureRunConfigurationExists));
                }
                MvcModuleStructureSynchronizer.this.scheduleRunActions();
                MvcModuleStructureSynchronizer.this.updateProjectViewVisibility();
            }
        });
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                Set set = MvcModuleStructureSynchronizer.this.myOrders;
                synchronized (set) {
                    MvcModuleStructureSynchronizer.this.myOrders.add(new Pair((Object)project, (Object)SyncAction.UpdateProjectStructure));
                    MvcModuleStructureSynchronizer.this.myOrders.add(new Pair((Object)project, (Object)SyncAction.CreateAppStructureIfNeeded));
                }
                MvcModuleStructureSynchronizer.this.scheduleRunActions();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){
            final ProjectFileIndex myFileIndex;
            {
                this.myFileIndex = ProjectFileIndex.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                VirtualFile file = event.getFile();
                if (!this.myFileIndex.isInContent(file)) {
                    return;
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                String fileName = event.getFileName();
                if ("application.properties".equals(fileName) || MvcModuleStructureSynchronizer.isApplicationDirectoryName(fileName)) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.EnsureRunConfigurationExists, file);
                } else if (MvcModuleStructureSynchronizer.isLibDirectory(file) || MvcModuleStructureSynchronizer.isLibDirectory(event.getParent())) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                } else {
                    if (!MvcModuleStructureSynchronizer.this.myProject.isInitialized()) {
                        return;
                    }
                    Module module = ProjectRootManager.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject).getFileIndex().getModuleForFile(file);
                    if (module == null) {
                        if (file.isDirectory()) {
                            if (MvcModuleStructureSynchronizer.this.myPluginRoots.contains(file.getParent())) {
                                MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, MvcModuleStructureSynchronizer.this.myProject);
                                return;
                            }
                            if (!MvcModuleStructureSynchronizer.this.myOutOfModuleDirectoryCreatedActionAdded) {
                                MvcModuleStructureSynchronizer.this.queue(SyncAction.OutOfModuleDirectoryCreated, MvcModuleStructureSynchronizer.this.myProject);
                                MvcModuleStructureSynchronizer.this.myOutOfModuleDirectoryCreatedActionAdded = true;
                            }
                        }
                        return;
                    }
                    if (!MvcConsole.isUpdatingVfsByConsoleProcess(module)) {
                        return;
                    }
                    MvcFramework framework = MvcFramework.getInstance(module);
                    if (framework == null) {
                        return;
                    }
                    if (framework.isToReformatOnCreation(file) || file.isDirectory()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!file.isValid()) {
                                return;
                            }
                            if (!framework.hasSupport(module)) {
                                return;
                            }
                            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                            if (file.isDirectory()) {
                                ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContentUnderDirectory(file, fileOrDir -> {
                                    if (!fileOrDir.isDirectory() && framework.isToReformatOnCreation(fileOrDir)) {
                                        files.add(file);
                                    }
                                    return true;
                                });
                            } else {
                                files.add(file);
                            }
                            PsiManager manager = PsiManager.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject);
                            for (VirtualFile virtualFile : files) {
                                PsiFile psiFile = manager.findFile(virtualFile);
                                if (psiFile == null) continue;
                                new ReformatCodeProcessor(MvcModuleStructureSynchronizer.this.myProject, psiFile, null, false).run();
                            }
                        }, module.getDisposed());
                    }
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                VirtualFile file = event.getFile();
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                if (MvcModuleStructureSynchronizer.isLibDirectory(file) || MvcModuleStructureSynchronizer.isLibDirectory(event.getParent())) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                VirtualFile file = event.getFile();
                if (!this.myFileIndex.isInContent(file)) {
                    return;
                }
                String fileName = event.getFileName();
                if ("application.properties".equals(fileName)) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (!this.myFileIndex.isInContent(event.getFile())) {
                    return;
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (!this.myFileIndex.isInContent(event.getFile())) {
                    return;
                }
                if ("name".equals(event.getPropertyName())) {
                    MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                }
            }
        }));
    }

    private static boolean isApplicationDirectoryName(String fileName) {
        for (MvcFramework framework : (MvcFramework[])MvcFramework.EP_NAME.getExtensions()) {
            if (!framework.getApplicationDirectoryName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLibDirectory(@Nullable VirtualFile file) {
        return file != null && "lib".equals(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(@NotNull SyncAction action, @NotNull Object on) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        synchronized (set) {
            this.myOrders.add((Pair<Object, SyncAction>)Pair.create((Object)on, (Object)((Object)action)));
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(this::scheduleRunActions);
    }

    private void scheduleRunActions() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ourGrailsTestFlag && !this.myProject.isInitialized()) {
                this.runActions(this.computeRawActions(this.takeOrderSnapshot()));
            }
            return;
        }
        ReadAction.nonBlocking(() -> this.computeRawActions(this.takeOrderSnapshot())).expireWith((Disposable)this).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.NON_MODAL, this::runActions).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashSet<Pair<Object, SyncAction>> takeOrderSnapshot() {
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        synchronized (set) {
            return new LinkedHashSet<Pair<Object, SyncAction>>(this.myOrders);
        }
    }

    @NotNull
    private List<Module> determineModuleBySyncActionObject(Object o) {
        VirtualFile file;
        if (o instanceof Module) {
            return Collections.singletonList((Module)o);
        }
        if (o instanceof Project) {
            return Arrays.asList(ModuleManager.getInstance((Project)((Project)o)).getModules());
        }
        if (o instanceof VirtualFile && (file = (VirtualFile)o).isValid()) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
            if (module == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(module);
        }
        return Collections.emptyList();
    }

    public static void forceUpdateProject(@NotNull Project project) {
        MvcModuleStructureSynchronizer instance = MvcModuleStructureSynchronizer.getInstance(project);
        instance.getFileAndRootsModificationTracker().incModificationCount();
        instance.runActions(instance.computeRawActions(instance.takeOrderSnapshot()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActions(Set<Trinity<Module, SyncAction, MvcFramework>> actions) {
        try {
            boolean isProjectStructureUpdated = false;
            for (Trinity<Module, SyncAction, MvcFramework> rawAction : actions) {
                Module module = (Module)rawAction.first;
                if (module.isDisposed()) continue;
                if (rawAction.second == SyncAction.UpdateProjectStructure && ((MvcFramework)rawAction.third).updatesWholeProject()) {
                    if (isProjectStructureUpdated) continue;
                    isProjectStructureUpdated = true;
                }
                ((SyncAction)((Object)rawAction.second)).doAction(module, (MvcFramework)rawAction.third);
            }
        }
        finally {
            Set<Pair<Object, SyncAction>> set = this.myOrders;
            synchronized (set) {
                this.myOrders.clear();
            }
        }
    }

    private Set<Trinity<Module, SyncAction, MvcFramework>> computeRawActions(Set<Pair<Object, SyncAction>> actions) {
        LinkedHashSet<Trinity<Module, SyncAction, MvcFramework>> rawActions = new LinkedHashSet<Trinity<Module, SyncAction, MvcFramework>>();
        for (Pair<Object, SyncAction> pair : actions) {
            for (Module module : this.determineModuleBySyncActionObject(pair.first)) {
                MvcFramework framework;
                if (module.isDisposed() || (framework = pair.second == SyncAction.CreateAppStructureIfNeeded ? MvcFramework.getInstanceBySdk(module) : MvcFramework.getInstance(module)) == null || framework.isAuxModule(module)) continue;
                rawActions.add((Trinity<Module, SyncAction, MvcFramework>)Trinity.create((Object)module, (Object)pair.second, (Object)framework));
            }
        }
        return rawActions;
    }

    private void updateProjectViewVisibility() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
            for (ToolWindowEP ep : ToolWindowEP.EP_NAME.getExtensionList()) {
                Class factoryClass = ep.getFactoryClass(ep.getPluginDescriptor());
                if (factoryClass == null || !MvcToolWindowDescriptor.class.isAssignableFrom(factoryClass)) continue;
                MvcToolWindowDescriptor descriptor = (MvcToolWindowDescriptor)ep.getToolWindowFactory(ep.getPluginDescriptor());
                String id = descriptor.getToolWindowId();
                boolean shouldShow = descriptor.value(this.myProject);
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
                ToolWindow toolWindow = toolWindowManager.getToolWindow(id);
                if (shouldShow && toolWindow == null) {
                    toolWindow = toolWindowManager.registerToolWindow(id, true, ToolWindowAnchor.LEFT, (Disposable)this.myProject, true);
                    toolWindow.setIcon(descriptor.getFramework().getToolWindowIcon());
                    descriptor.createToolWindowContent(this.myProject, toolWindow);
                    continue;
                }
                if (shouldShow || toolWindow == null) continue;
                toolWindowManager.unregisterToolWindow(id);
                Disposer.dispose((Disposable)toolWindow.getContentManager());
            }
        }, this.myProject.getDisposed()));
    }

    public static enum SyncAction {
        SyncLibrariesInPluginsModule{

            @Override
            void doAction(Module module, MvcFramework framework) {
                if (MvcModuleStructureUtil.isEnabledStructureUpdate()) {
                    framework.syncSdkAndLibrariesInPluginsModule(module);
                }
            }
        }
        ,
        UpgradeFramework{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.upgradeFramework(module);
            }
        }
        ,
        CreateAppStructureIfNeeded{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.createApplicationIfNeeded(module);
            }
        }
        ,
        UpdateProjectStructure{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.updateProjectStructure(module);
            }
        }
        ,
        EnsureRunConfigurationExists{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.ensureRunConfigurationExists(module);
            }
        }
        ,
        OutOfModuleDirectoryCreated{

            @Override
            void doAction(Module module, MvcFramework framework) {
                Project project = module.getProject();
                MvcModuleStructureSynchronizer mvcModuleStructureSynchronizer = MvcModuleStructureSynchronizer.getInstance(project);
                if (mvcModuleStructureSynchronizer.myOutOfModuleDirectoryCreatedActionAdded) {
                    mvcModuleStructureSynchronizer.myOutOfModuleDirectoryCreatedActionAdded = false;
                    HashSet roots = new HashSet();
                    for (String rootPath : MvcWatchedRootProvider.getRootsToWatch(project)) {
                        ContainerUtil.addIfNotNull(roots, (Object)LocalFileSystem.getInstance().findFileByPath(rootPath));
                    }
                    if (!roots.equals(mvcModuleStructureSynchronizer.myPluginRoots)) {
                        mvcModuleStructureSynchronizer.myPluginRoots = roots;
                        ApplicationManager.getApplication().invokeLater(() -> mvcModuleStructureSynchronizer.queue(UpdateProjectStructure, project));
                    }
                }
            }
        };


        abstract void doAction(Module var1, MvcFramework var2);
    }

    static final class MyPostStartUpActivity
    implements StartupActivity.DumbAware {
        MyPostStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            GuiUtils.invokeLaterIfNeeded(() -> MvcModuleStructureSynchronizer.getInstance(project).projectOpened(), (ModalityState)ModalityState.NON_MODAL, (Condition)project.getDisposed());
        }
    }
}

