/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

public class GrDescriptorReturnTypeCalculator
implements GrTypeCalculator<GrMethodCall> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrMethodCall callExpression) {
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        for (GroovyMethodInfo methodInfo : GroovyMethodInfo.getInfos(method)) {
            PsiType result2;
            String returnType2 = methodInfo.getReturnType();
            if (returnType2 != null) {
                if (!methodInfo.isApplicable(method)) continue;
                return JavaPsiFacade.getElementFactory((Project)callExpression.getProject()).createTypeFromText(returnType2, (PsiElement)callExpression);
            }
            if (!methodInfo.isReturnTypeCalculatorDefined() || !methodInfo.isApplicable(method) || (result2 = (PsiType)methodInfo.getReturnTypeCalculator().fun((Object)callExpression, (Object)method)) == null) continue;
            return result2;
        }
        return null;
    }
}

