/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.clauses;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrForInClauseImpl
extends GroovyPsiElementImpl
implements GrForInClause {
    public GrForInClauseImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitForInClause(this);
    }

    public String toString() {
        return "In clause";
    }

    @Override
    public GrParameter getDeclaredVariable() {
        return (GrParameter)this.findChildByClass(GrParameter.class);
    }

    @Override
    @Nullable
    public GrExpression getIteratedExpression() {
        return GrForInClauseImpl.findExpressionChild(this);
    }

    @Override
    @NotNull
    public PsiElement getDelimiter() {
        PsiElement in = this.findChildByType(GroovyTokenTypes.kIN);
        if (in != null) {
            return in;
        }
        PsiElement colon = this.findChildByType(GroovyTokenTypes.mCOLON);
        return Objects.requireNonNull(colon);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent != null) {
            return true;
        }
        GrParameter variable = this.getDeclaredVariable();
        if (variable == null) {
            return true;
        }
        return ResolveUtil.processElement(processor, (PsiNamedElement)variable, state);
    }
}

