/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.base;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;

public abstract class Intention
implements IntentionAction {
    private final PsiElementPredicate predicate = this.getElementPredicate();

    protected Intention() {
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element = this.findMatchingElement(file, editor);
        if (element == null) {
            return;
        }
        assert (element.isValid()) : element;
        this.processIntention(element, project, editor);
    }

    protected abstract void processIntention(@NotNull PsiElement var1, @NotNull Project var2, Editor var3) throws IncorrectOperationException;

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull GrExpression expression) throws IncorrectOperationException {
        String expString;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression expressionToReplace = expression;
        if (BoolUtils.isNegated(expression)) {
            expressionToReplace = BoolUtils.findNegation(expression);
            expString = newExpression;
        } else {
            expString = "!(" + newExpression + ')';
        }
        GrExpression newCall = factory.createExpressionFromText(expString, expression.getContext());
        assert (expressionToReplace != null);
        expressionToReplace.replaceWithExpression(newCall, true);
    }

    @Nullable
    PsiElement findMatchingElement(PsiFile file, Editor editor) {
        PsiElement element;
        if (!file.getViewProvider().getLanguages().contains((Object)GroovyLanguage.INSTANCE)) {
            return null;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            if (0 <= start && start <= end) {
                TextRange selectionRange = new TextRange(start, end);
                for (PsiElement element2 = PsiImplUtil.findElementInRange(file, start, end, PsiElement.class); element2 != null && element2.getTextRange() != null && selectionRange.contains(element2.getTextRange()); element2 = element2.getParent()) {
                    if (!this.predicate.satisfiedBy(element2)) continue;
                    return element2;
                }
            }
        }
        int position = editor.getCaretModel().getOffset();
        for (element = file.findElementAt(position); element != null; element = element.getParent()) {
            if (this.predicate.satisfiedBy(element)) {
                return element;
            }
            if (this.isStopElement(element)) break;
        }
        for (element = file.findElementAt(position - 1); element != null; element = element.getParent()) {
            if (this.predicate.satisfiedBy(element)) {
                return element;
            }
            if (!this.isStopElement(element)) continue;
            return null;
        }
        return null;
    }

    protected boolean isStopElement(PsiElement element) {
        return element instanceof PsiFile;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.findMatchingElement(file, editor) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private String getPrefix() {
        Class<?> aClass = this.getClass();
        String name = aClass.getSimpleName();
        StringBuilder buffer = new StringBuilder(name.length() + 10);
        buffer.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    public String getText() {
        return GroovyIntentionsBundle.message(this.getPrefix() + ".name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return GroovyIntentionsBundle.message(this.getPrefix() + ".family.name", new Object[0]);
    }
}

