/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class SpockVariableDescriptor {
    private final String myName;
    private final PsiElement myNavigationElement;
    private final List<GrExpression> myExpressions;
    private List<GrExpression> myExpressionsOfCollection;
    private PsiVariable myVariable;

    public SpockVariableDescriptor(PsiElement navigationElement, String name) {
        this.myName = name;
        this.myNavigationElement = navigationElement;
        this.myExpressions = new ArrayList<GrExpression>();
    }

    public SpockVariableDescriptor addExpression(@Nullable GrExpression expression) {
        this.myExpressions.add(expression);
        return this;
    }

    public SpockVariableDescriptor addExpressionOfCollection(@Nullable GrExpression expression) {
        if (this.myExpressionsOfCollection == null) {
            this.myExpressionsOfCollection = new ArrayList<GrExpression>();
        }
        this.myExpressionsOfCollection.add(expression);
        return this;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement getNavigationElement() {
        return this.myNavigationElement;
    }

    public PsiVariable getVariable() {
        if (this.myVariable == null) {
            PsiType type2 = this.getType();
            this.myVariable = new SpockVariable(this.myNavigationElement.getManager(), this.myName, type2, this.myNavigationElement);
        }
        return this.myVariable;
    }

    @VisibleForTesting
    @NotNull
    public PsiType getType() {
        PsiManager manager = this.myNavigationElement.getManager();
        PsiType type2 = (PsiType)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, () -> {
            PsiType res = null;
            for (GrExpression expression : this.myExpressions) {
                if (expression == null) continue;
                res = TypesUtil.getLeastUpperBoundNullable(res, expression.getType(), manager);
            }
            if (this.myExpressionsOfCollection != null) {
                for (GrExpression expression : this.myExpressionsOfCollection) {
                    if (expression == null) continue;
                    PsiType listType = expression.getType();
                    PsiType type1 = PsiUtil.extractIterableTypeParameter((PsiType)listType, (boolean)true);
                    if (type1 == null) {
                        if (listType == null) continue;
                        if (listType.equalsToText("java.lang.String")) {
                            type1 = PsiType.getJavaLangString((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
                        }
                    }
                    res = TypesUtil.getLeastUpperBoundNullable(res, type1, manager);
                }
            }
            return res;
        });
        if (type2 == null) {
            return PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)this.myNavigationElement.getResolveScope());
        }
        return type2;
    }

    public String toString() {
        return this.myName;
    }

    private static class SpockVariable
    extends GrLightVariable {
        SpockVariable(PsiManager manager, @NonNls String name, @NotNull PsiType type2, @NotNull PsiElement navigationElement) {
            super(manager, name, type2, navigationElement);
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return super.isEquivalentTo(another) || another instanceof SpockVariable && this.getNavigationElement() == another.getNavigationElement();
        }
    }
}

