/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions.joinLines;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GrJoinControlStatementHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        if (!(file instanceof GroovyFileBase)) {
            return -1;
        }
        PsiElement startElement = file.findElementAt(start);
        if (startElement == null || !startElement.getNode().getElementType().equals(GroovyTokenTypes.mRPAREN)) {
            return -1;
        }
        PsiElement parent2 = startElement.getParent();
        if (!(parent2 instanceof GrIfStatement || parent2 instanceof GrWhileStatement || parent2 instanceof GrForStatement)) {
            return -1;
        }
        GrStatement inner = parent2 instanceof GrIfStatement ? ((GrIfStatement)parent2).getThenBranch() : (parent2 instanceof GrWhileStatement ? ((GrWhileStatement)parent2).getBody() : ((GrForStatement)parent2).getBody());
        if (inner instanceof GrBlockStatement) {
            return -1;
        }
        document.replaceString(start + 1, end, (CharSequence)" ");
        return start + 2;
    }
}

