/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesFilter;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;

public class GroovyStripTrailingSpacesFilterFactory
extends PsiBasedStripTrailingSpacesFilter.Factory {
    @NotNull
    protected PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document document) {
        return new GroovyStripTrailingSpacesFilter(document);
    }

    protected boolean isApplicableTo(@NotNull Language language) {
        return language.is((Language)GroovyLanguage.INSTANCE);
    }

    private static class GroovyStripTrailingSpacesFilter
    extends PsiBasedStripTrailingSpacesFilter {
        protected GroovyStripTrailingSpacesFilter(@NotNull Document document) {
            super(document);
        }

        protected void process(@NotNull PsiFile psiFile) {
            psiFile.accept((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitGStringExpression(@NotNull GrString gstring) {
                    this.disableRange(gstring.getTextRange(), false);
                }

                @Override
                public void visitLiteralExpression(@NotNull GrLiteral literal) {
                    this.disableRange(literal.getTextRange(), false);
                }
            }));
        }
    }
}

