/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GroovyOctalIntegerInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Octal integer #ref #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitLiteralExpression(@NotNull GrLiteral literal) {
                super.visitLiteralExpression(literal);
                String text = literal.getText();
                if (!text.startsWith("0")) {
                    return;
                }
                if (text.replaceAll("0", "").isEmpty()) {
                    return;
                }
                if ("0g".equals(text) || "0G".equals(text)) {
                    return;
                }
                if ("0i".equals(text) || "0I".equals(text)) {
                    return;
                }
                if ("0l".equals(text) || "0L".equals(text)) {
                    return;
                }
                if (text.startsWith("0x") || text.startsWith("0X")) {
                    return;
                }
                if (text.startsWith("0b") || text.startsWith("0B")) {
                    return;
                }
                if (text.endsWith("d") || text.endsWith("D")) {
                    return;
                }
                if (text.endsWith("f") || text.endsWith("F")) {
                    return;
                }
                if (text.contains(".") || text.contains("e") || text.contains("E")) {
                    return;
                }
                this.registerError(literal);
            }
        };
    }
}

