/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

class CompareToTransformation
extends BinaryTransformation {
    @NotNull
    private final IElementType myElementType;

    CompareToTransformation(@NotNull IElementType elementType) {
        this.myElementType = elementType;
    }

    @Override
    public void apply(@NotNull GrBinaryExpression expression) {
        GrExpression lhsParenthesized = this.addParenthesesIfNeeded(this.getLhs(expression));
        String compare = "";
        if (this.myElementType != GroovyTokenTypes.mCOMPARE_TO) {
            compare = String.format(" %s 0", this.myElementType.toString());
        }
        GrInspectionUtil.replaceExpression(expression, String.format("%s.compareTo(%s) %s", lhsParenthesized.getText(), this.getRhs(expression).getText(), compare));
    }

    @Override
    public String getMethod() {
        return "compareTo";
    }
}

