/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements;

import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DNamedElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DTypedElement;

public abstract class DItemElement
implements DNamedElement,
DTypedElement,
Comparable {
    public String myType;
    public Boolean myStatic;
    public String myName;
    public String myHighlightedText = null;

    public DItemElement(@Nullable Boolean isStatic, @Nullable String name, @Nullable String type2) {
        this.myStatic = isStatic;
        this.myName = name;
        this.myType = type2;
    }

    public String getHighlightedText() {
        return this.myHighlightedText;
    }

    public void setHighlightedText(String highlightedText) {
        this.myHighlightedText = highlightedText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DItemElement that = (DItemElement)o;
        if (this.myName != null ? !this.myName.equals(that.myName) : that.myName != null) {
            return false;
        }
        if (this.myType != null ? !this.myType.equals(that.myType) : that.myType != null) {
            return false;
        }
        return this.myStatic == that.myStatic;
    }

    public int hashCode() {
        int result2 = this.myType != null ? this.myType.hashCode() : 0;
        result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
        return result2;
    }

    @Override
    public String getType() {
        return this.myType;
    }

    @Override
    public void setType(String type2) {
        this.myType = type2;
        this.clearCache();
    }

    public abstract void clearCache();

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
        this.clearCache();
    }

    public Boolean isStatic() {
        return this.myStatic;
    }

    public void setStatic(Boolean aStatic) {
        this.myStatic = aStatic;
        this.clearCache();
    }

    public int compareTo(Object o) {
        if (!(o instanceof DItemElement)) {
            return 0;
        }
        DItemElement otherProperty = (DItemElement)o;
        return this.getName().compareTo(otherProperty.getName()) + this.getType().compareTo(otherProperty.getType());
    }

    @NotNull
    public abstract PsiNamedElement getPsi(PsiManager var1, String var2);
}

