/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016H\u0000\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001f"}, d2={"VARIABLE_MODIFIERS", "", "", "getVARIABLE_MODIFIERS", "()Ljava/util/Set;", "checkModifierIsNotAllowed", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "modifier", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "message", "checkVariableModifiers", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "registerLocalFix", "Lcom/intellij/lang/annotation/AnnotationBuilder;", "annotationBuilder", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "place", "Lcom/intellij/psi/PsiElement;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "range", "Lcom/intellij/openapi/util/TextRange;", "createDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/lang/annotation/Annotation;", "element", "intellij.groovy.psi"})
public final class UtilKt {
    @NotNull
    private static final Set<String> VARIABLE_MODIFIERS = SetsKt.setOf((Object[])new String[]{"def", "final"});

    @NotNull
    public static final Set<String> getVARIABLE_MODIFIERS() {
        return VARIABLE_MODIFIERS;
    }

    public static final void checkVariableModifiers(@NotNull AnnotationHolder holder, @NotNull GrVariableDeclaration variableDeclaration) {
        GrModifierList modifierList = variableDeclaration.getModifierList();
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (VARIABLE_MODIFIERS.contains(modifier)) continue;
            UtilKt.checkModifierIsNotAllowed(modifierList, modifier, GroovyBundle.message("variable.cannot.be", modifier), holder);
        }
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @NotNull AnnotationHolder holder) {
        UtilKt.checkModifierIsNotAllowed(modifierList, modifier, GroovyBundle.message("modifier.0.not.allowed", modifier), holder);
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @NotNull String message, @NotNull AnnotationHolder holder) {
        PsiElement psiElement = modifierList.getModifier(modifier);
        if (psiElement == null) {
            return;
        }
        PsiElement modifierElement = psiElement;
        AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(modifierElement);
        GrRemoveModifierFix fix = new GrRemoveModifierFix(modifier, GroovyBundle.message("remove.modifier", modifier));
        builder = UtilKt.registerLocalFix(builder, fix, modifierElement, message, ProblemHighlightType.ERROR, modifierElement.getTextRange());
        builder.create();
    }

    @NotNull
    public static final AnnotationBuilder registerLocalFix(@NotNull AnnotationBuilder annotationBuilder, @NotNull LocalQuickFix fix, @NotNull PsiElement place, @NotNull String message, @NotNull ProblemHighlightType problemHighlightType, @NotNull TextRange range) {
        InspectionManager manager = InspectionManager.getInstance((Project)place.getProject());
        boolean bl = !place.getTextRange().isEmpty();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = place.getContainingFile().getName();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor(place, place, message, problemHighlightType, true, new LocalQuickFix[0]);
        return annotationBuilder.newLocalQuickFix(fix, descriptor).range(range).registerFix();
    }

    @NotNull
    public static final ProblemDescriptor createDescriptor(@NotNull Annotation $this$createDescriptor, @NotNull PsiElement element) {
        return InspectionManager.getInstance((Project)element.getProject()).createProblemDescriptor(element, element, $this$createDescriptor.getMessage(), $this$createDescriptor.getHighlightType(), true, new LocalQuickFix[0]);
    }
}

