/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.io.BaseOutputReader;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingProcessHandler
extends OSProcessHandler {
    private final CapturingProcessRunner myProcessRunner = new CapturingProcessRunner((BaseProcessHandler<?>)this, (Function<? super ProcessOutput, ? extends ProcessAdapter>)((Function<ProcessOutput, ProcessAdapter>)processOutput -> this.createProcessAdapter((ProcessOutput)processOutput)));

    public CapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public CapturingProcessHandler(@NotNull Process process2) {
        this(process2, null, "");
        DeprecatedMethodException.report((String)"Use CapturingProcessHandler(Process, Charset, String) instead");
    }

    public CapturingProcessHandler(@NotNull Process process2, @Nullable Charset charset, String commandLine) {
        super(process2, commandLine, charset);
    }

    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new CapturingProcessAdapter(processOutput);
    }

    public Charset getCharset() {
        return this.myCharset != null ? this.myCharset : super.getCharset();
    }

    @NotNull
    public ProcessOutput runProcess() {
        return this.myProcessRunner.runProcess();
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        return this.myProcessRunner.runProcess(timeoutInMilliseconds);
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        return this.myProcessRunner.runProcess(timeoutInMilliseconds, destroyOnTimeout);
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator) {
        return this.myProcessRunner.runProcess(indicator);
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds) {
        return this.myProcessRunner.runProcess(indicator, timeoutInMilliseconds);
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds, boolean destroyOnTimeout) {
        return this.myProcessRunner.runProcess(indicator, timeoutInMilliseconds, destroyOnTimeout);
    }

    public static class Silent
    extends CapturingProcessHandler {
        public Silent(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            super(commandLine);
        }

        public Silent(@NotNull Process process2, @Nullable Charset charset, @NotNull String commandLine) {
            super(process2, charset, commandLine);
        }

        @Override
        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return BaseOutputReader.Options.forMostlySilentProcess();
        }
    }
}

