/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.game.GameToolsServer$WhenMappings;
import com.android.tools.game.ProfilerService;
import com.android.tools.game.ProfilerServiceImpl;
import com.android.tools.game.ProjectService;
import com.android.tools.game.ProjectServiceImpl;
import com.android.tools.game.ProjectWrapper;
import com.android.tools.game.WindowWrapper;
import com.android.tools.game.protos.CreateProjectRequest;
import com.android.tools.game.protos.CreateWindowRequest;
import com.android.tools.game.protos.GameToolsGrpc;
import com.android.tools.game.protos.Project;
import com.android.tools.game.protos.StartProfilingRequest;
import com.android.tools.game.protos.StartProfilingResponse;
import com.android.tools.game.protos.Window;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.util.TransmitStatusRuntimeExceptionInterceptor;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0016J\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\rJ\u001e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00192\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/game/GameToolsServer;", "Lcom/android/tools/game/protos/GameToolsGrpc$GameToolsImplBase;", "port", "", "projectService", "Lcom/android/tools/game/ProjectService;", "profilerService", "Lcom/android/tools/game/ProfilerService;", "(ILcom/android/tools/game/ProjectService;Lcom/android/tools/game/ProfilerService;)V", "server", "Lio/grpc/Server;", "kotlin.jvm.PlatformType", "createProject", "", "request", "Lcom/android/tools/game/protos/CreateProjectRequest;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lcom/android/tools/game/protos/Project;", "createWindow", "Lcom/android/tools/game/protos/CreateWindowRequest;", "Lcom/android/tools/game/protos/Window;", "shutdown", "start", "startProfiling", "Lcom/android/tools/game/protos/StartProfilingRequest;", "Lcom/android/tools/game/protos/StartProfilingResponse;", "android.game-tools.main"})
public final class GameToolsServer
extends GameToolsGrpc.GameToolsImplBase {
    private final Server server;
    private final int port;
    private final ProjectService projectService;
    private final ProfilerService profilerService;

    public final void start() {
        this.server.start();
        boolean $i$f$logger = false;
        Logger.getInstance(GameToolsServer.class).info("GameToolsServer started at port " + this.server.getPort());
    }

    public final void shutdown() {
        this.server.shutdown();
        this.server.awaitTermination(1L, TimeUnit.MINUTES);
    }

    public void createProject(@NotNull CreateProjectRequest request, @NotNull StreamObserver<Project> responseObserver) {
        Project project = request.getProject();
        String string = project.getName();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string2 = !StringsKt.isBlank((CharSequence)charSequence) ? string : null;
        if (string2 == null) {
            throw (Throwable)Status.INVALID_ARGUMENT.withDescription("'project.name' field is required.").asRuntimeException();
        }
        String name = string2;
        String string3 = project.getPath();
        bl2 = false;
        boolean bl5 = false;
        String it2 = string3;
        boolean bl6 = false;
        CharSequence charSequence2 = it2;
        boolean bl7 = false;
        String string4 = !StringsKt.isBlank((CharSequence)charSequence2) ? string3 : null;
        if (string4 == null) {
            throw (Throwable)Status.INVALID_ARGUMENT.withDescription("'project.path' field is required.").asRuntimeException();
        }
        String path = string4;
        ProjectWrapper createdProject = this.projectService.createProject(name, Paths.get(path, new String[0]));
        responseObserver.onNext((Object)createdProject.asGrpcProject());
        responseObserver.onCompleted();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createWindow(@NotNull CreateWindowRequest request, @NotNull StreamObserver<Window> responseObserver) {
        Window.WindowType windowType = request.getWindow().getType();
        if (windowType == null) throw (Throwable)Status.INVALID_ARGUMENT.withDescription("Unknown window type '" + request.getWindow().getType() + "'.").asRuntimeException();
        switch (GameToolsServer$WhenMappings.$EnumSwitchMapping$0[windowType.ordinal()]) {
            case 1: {
                ProjectWrapper project = this.projectService.getProject(request.getProjectId());
                WindowWrapper window = ProfilerService.DefaultImpls.createProfilerWindow$default(this.profilerService, project, null, 2, null);
                responseObserver.onNext((Object)window.asGrpcWindow());
                responseObserver.onCompleted();
                return;
            }
            default: {
                throw (Throwable)Status.INVALID_ARGUMENT.withDescription("Unknown window type '" + request.getWindow().getType() + "'.").asRuntimeException();
            }
        }
    }

    public void startProfiling(@NotNull StartProfilingRequest request, @NotNull StreamObserver<StartProfilingResponse> responseObserver) {
        this.profilerService.startProfiler(request);
        responseObserver.onNext((Object)StartProfilingResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public GameToolsServer(int port, @NotNull ProjectService projectService, @NotNull ProfilerService profilerService) {
        this.port = port;
        this.projectService = projectService;
        this.profilerService = profilerService;
        this.server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService((BindableService)this)).intercept(TransmitStatusRuntimeExceptionInterceptor.instance())).build();
    }

    public /* synthetic */ GameToolsServer(int n, ProjectService projectService, ProfilerService profilerService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            projectService = new ProjectServiceImpl();
        }
        if ((n2 & 4) != 0) {
            profilerService = new ProfilerServiceImpl();
        }
        this(n, projectService, profilerService);
    }
}

