/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.jetbrains.annotations.NotNull;

public class RelaxSymbolIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> NAME = ID.create((String)"RelaxSymbolIndex");

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                Grammar grammar;
                PsiFile file;
                final HashMap<String, Void> map = new HashMap<String, Void>();
                if (inputData.getFileType() == XmlFileType.INSTANCE) {
                    CharSequence inputDataContentAsText = inputData.getContentAsText();
                    if (CharArrayUtil.indexOf((CharSequence)inputDataContentAsText, (CharSequence)"http://relaxng.org/ns/structure/1.0", (int)0) == -1) {
                        return Collections.emptyMap();
                    }
                    NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlBuilder(){
                        NanoXmlBuilder attributeHandler;
                        int depth;

                        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                            if (this.attributeHandler != null) {
                                this.attributeHandler.addAttribute(key, nsPrefix, nsURI, value, type);
                            }
                        }

                        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
                            this.attributeHandler = null;
                            if (this.depth == 1 && "http://relaxng.org/ns/structure/1.0".equals(nsURI) && "define".equals(name)) {
                                this.attributeHandler = new NanoXmlBuilder(){

                                    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
                                        if ("name".equals(key) && (nsURI == null || nsURI.length() == 0) && value != null) {
                                            map.put(value, null);
                                        }
                                    }
                                };
                            }
                            ++this.depth;
                        }

                        public void endElement(String name, String nsPrefix, String nsURI) {
                            this.attributeHandler = null;
                            --this.depth;
                        }
                    });
                } else if (inputData.getFileType() == RncFileType.getInstance() && (file = inputData.getPsiFile()) instanceof XmlFile && (grammar = GrammarFactory.getGrammar((XmlFile)file)) != null) {
                    grammar.acceptChildren(new CommonElement.Visitor(){

                        public void visitDefine(Define define) {
                            String name = define.getName();
                            if (name != null) {
                                map.put(name, null);
                            }
                        }
                    });
                }
                return map;
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML, RncFileType.getInstance()}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                return !(file.getFileSystem() instanceof JarFileSystem);
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }
}

