/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.EmptyResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.RncPattern;
import org.intellij.plugins.relaxNG.compact.psi.RncRef;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatternReference
extends PsiReferenceBase.Poly<RncRef>
implements Function<Define, ResolveResult>,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    PatternReference(RncRef ref) {
        super((PsiElement)ref);
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode node = this.findNameNode();
        if (node == null) {
            return TextRange.from((int)0, (int)0);
        }
        int offset = ((RncRef)this.myElement).getTextOffset();
        return TextRange.from((int)(offset - ((RncRef)this.myElement).getTextRange().getStartOffset()), (int)node.getTextLength());
    }

    private ASTNode findNameNode() {
        ASTNode node = ((RncRef)this.myElement).getNode();
        assert (node != null);
        return node.findChildByType(RncTokenTypes.IDENTIFIERS);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        RncGrammar scope = this.getScope();
        if (scope == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        Set<Define> set = DefinitionResolver.resolve(scope, this.getCanonicalText());
        if (set == null || set.size() == 0) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return (ResolveResult[])ContainerUtil.map2Array(set, ResolveResult.class, (Function)this);
    }

    public ResolveResult fun(Define rncDefine) {
        Object element = rncDefine.getPsiElement();
        return element != null ? new PsiElementResolveResult(element) : EmptyResolveResult.INSTANCE;
    }

    @Nullable
    protected RncGrammar getScope() {
        return (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, RncGrammar.class, (boolean)true, (Class[])new Class[]{PsiFile.class});
    }

    @NotNull
    public String getCanonicalText() {
        ASTNode node = this.findNameNode();
        return node != null ? EscapeUtil.unescapeText(node) : "";
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode newNode = RenameUtil.createIdentifierNode(((RncRef)this.getElement()).getManager(), newElementName);
        ASTNode nameNode = this.findNameNode();
        nameNode.getTreeParent().replaceChild(nameNode, newNode);
        return this.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public Object @NotNull [] getVariants() {
        RncGrammar scope = this.getScope();
        if (scope == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        Map<String, Set<Define>> map = DefinitionResolver.getAllVariants(scope);
        if (map == null || map.size() == 0) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        return ContainerUtil.mapNotNull(map.values(), defines -> defines.size() == 0 ? null : ((Define)defines.iterator().next()).getPsiElement()).toArray();
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return RelaxngBundle.message("unresolved.pattern.reference.0", new Object[0]);
    }

    public LocalQuickFix @Nullable [] getQuickFixes() {
        if (this.getScope() != null) {
            return new LocalQuickFix[]{new CreatePatternFix(this)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    static class CreatePatternFix
    implements LocalQuickFix {
        private final PatternReference myReference;

        CreatePatternFix(PatternReference reference) {
            this.myReference = reference;
        }

        @NotNull
        public String getName() {
            return RelaxngBundle.message("create.pattern.0", this.myReference.getCanonicalText());
        }

        @NotNull
        public String getFamilyName() {
            return RelaxngBundle.message("create.pattern", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RncFile rncfile = (RncFile)PsiFileFactory.getInstance((Project)((RncRef)this.myReference.getElement()).getProject()).createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)"dummy = xxx");
            RncGrammar grammar = rncfile.getGrammar();
            assert (grammar != null);
            RncDefine def = (RncDefine)grammar.getFirstChild();
            RncGrammar scope = this.myReference.getScope();
            assert (scope != null);
            assert (def != null);
            RncDefine e = (RncDefine)scope.add(def);
            def.setName(this.myReference.getCanonicalText());
            SmartPsiElementPointer p = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)e);
            ASTNode blockNode = e.getParent().getNode();
            assert (blockNode != null);
            ASTNode newNode = e.getNode();
            assert (newNode != null);
            CodeStyleManager.getInstance((Project)e.getManager().getProject()).reformatNewlyAddedElement(blockNode, newNode);
            RncDefine d = (RncDefine)p.getElement();
            assert (d != null);
            RncPattern definition = d.getPattern();
            assert (definition != null);
            int offset = definition.getTextRange().getStartOffset();
            definition.delete();
            VirtualFile virtualFile = ((RncRef)this.myReference.getElement()).getContainingFile().getVirtualFile();
            if (virtualFile != null) {
                FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), true);
            }
        }
    }
}

