/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.psi.XmlPsiBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEnumeratedValueReference
extends PsiReferenceBase<XmlElement>
implements EmptyResolveMessageProvider,
ResolvingHint {
    private final XmlEnumerationDescriptor myDescriptor;

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor) {
        super((PsiElement)value);
        this.myDescriptor = descriptor;
    }

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor, TextRange range) {
        super((PsiElement)value, range);
        this.myDescriptor = descriptor;
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(XmlElement.class, elementClass);
    }

    @Nullable
    public PsiElement resolve() {
        return this.myDescriptor.getValueDeclaration((XmlElement)this.getElement(), this.getValue());
    }

    public Object @NotNull [] getVariants() {
        if (this.myDescriptor.isFixed()) {
            Object[] objectArray;
            String defaultValue = this.myDescriptor.getDefaultValue();
            if (defaultValue == null) {
                objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = defaultValue;
            }
            return objectArray;
        }
        String[] values = this.myDescriptor.getValuesForCompletion();
        return values == null ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : values;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String name = this.getElement() instanceof XmlTag ? "tag" : "attribute";
        return this.myDescriptor.isFixed() ? XmlPsiBundle.message((String)"should.have.fixed.value", (Object[])new Object[]{StringUtil.capitalize((String)name), this.myDescriptor.getDefaultValue()}) : XmlPsiBundle.message((String)"wrong.value", (Object[])new Object[]{name});
    }
}

