/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateXmlBlock;
import com.intellij.xml.template.formatter.TemplateXmlTagBlock;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TemplateSyntheticBlock
extends SyntheticBlock
implements IndentInheritingBlock {
    private Indent myInheritedIndent;

    public TemplateSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        super(subBlocks, parent, indent, policy, childIndent);
    }

    @Override
    public void setIndent(Indent indent) {
        this.myInheritedIndent = indent;
    }

    @Override
    public Indent getIndent() {
        return this.myInheritedIndent != null ? this.myInheritedIndent : super.getIndent();
    }

    @Override
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child1 != null && TemplateSyntheticBlock.isXmlBlock(child1) != TemplateSyntheticBlock.isXmlBlock(child2)) {
            if (this.shouldKeepWhiteSpacesInside()) {
                return Spacing.getReadOnlySpacing();
            }
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return super.getSpacing(child1, child2);
    }

    private static boolean isXmlBlock(@NotNull Block block) {
        if (block instanceof TemplateXmlTagBlock || block instanceof TemplateXmlBlock) {
            return true;
        }
        if (block instanceof ASTBlock) {
            ASTNode node = ((ASTBlock)block).getNode();
            return node != null && node.getPsi().getLanguage().isKindOf((Language)XMLLanguage.INSTANCE);
        }
        return false;
    }
}

