/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.actions.validate.StdErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.actions.validate.ValidateXmlHandler;
import org.jetbrains.annotations.NotNull;

public class ValidateXmlAction
extends AnAction {
    private static final Key<String> runningValidationKey = Key.create((String)"xml.running.validation.indicator");

    private ValidateXmlHandler getHandler(@NotNull PsiFile file) {
        for (ValidateXmlHandler handler : ValidateXmlHandler.EP_NAME.getExtensionList()) {
            if (!handler.isAvailable((XmlFile)file)) continue;
            return handler;
        }
        ValidateXmlActionHandler handler = new ValidateXmlActionHandler(true);
        handler.setErrorReporter(new StdErrorReporter(handler, file, () -> this.doRunAction(file)));
        return handler;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile != null && psiFile.getVirtualFile() != null) {
            this.doRunAction(psiFile);
        }
    }

    private void doRunAction(@NotNull PsiFile psiFile) {
        CommandProcessor.getInstance().executeCommand(psiFile.getProject(), () -> {
            Runnable action = () -> {
                try {
                    psiFile.putUserData(runningValidationKey, (Object)"");
                    PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                    this.getHandler(psiFile).doValidate((XmlFile)psiFile);
                }
                finally {
                    psiFile.putUserData(runningValidationKey, null);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, this.getCommandName(), null);
    }

    private String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text != null ? text : "";
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_FILE);
        boolean visible = psiElement instanceof XmlFile;
        presentation.setVisible(visible);
        boolean enabled = psiElement instanceof XmlFile;
        if (enabled) {
            PsiFile containingFile = psiElement.getContainingFile();
            enabled = containingFile != null && containingFile.getVirtualFile() != null && (containingFile.getFileType() == StdFileTypes.XML || containingFile.getFileType() == StdFileTypes.XHTML) ? containingFile.getUserData(runningValidationKey) == null : false;
        }
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        }
    }
}

