/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.MultiFileNsDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlPsiUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class XmlTagDelegate {
    private static final Logger LOG = Logger.getInstance(XmlTagDelegate.class);
    @NonNls
    private static final String XML_NS_PREFIX = "xml";
    private static final Key<CachedValue<XmlTag[]>> SUBTAGS_WITH_INCLUDES_KEY = Key.create((String)"subtags with includes");
    private static final Key<CachedValue<XmlTag[]>> SUBTAGS_WITHOUT_INCLUDES_KEY = Key.create((String)"subtags without includes");
    private static final Comparator<TextRange> RANGE_COMPARATOR = Comparator.comparingInt(TextRange::getStartOffset);
    @NotNull
    protected final XmlTag myTag;
    private volatile String myName;
    private volatile String myLocalName;
    private volatile TextRange[] myTextElements;
    private volatile Map<String, String> myAttributeValueMap;
    private volatile Boolean myHasNamespaceDeclarations;

    public XmlTagDelegate(@NotNull XmlTag tag) {
        this.myTag = tag;
    }

    protected abstract void deleteChildInternalSuper(@NotNull ASTNode var1);

    protected abstract TreeElement addInternalSuper(TreeElement var1, ASTNode var2, @Nullable ASTNode var3, @Nullable Boolean var4);

    protected XmlTag createTag(String name, String tagValue) {
        return XmlElementFactory.getInstance((Project)this.myTag.getProject()).createTagFromText(XmlTagUtil.composeTagText((String)name, (String)tagValue));
    }

    protected XmlAttribute createAttribute(@NotNull String qname, @NotNull String value) {
        return XmlElementFactory.getInstance((Project)this.myTag.getProject()).createAttribute(qname, value, (PsiElement)this.myTag);
    }

    protected XmlTag createTagFromText(String text) {
        return XmlElementFactory.getInstance((Project)this.myTag.getProject()).createTagFromText((CharSequence)text);
    }

    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        attributesValueMap.put(name, value);
    }

    public boolean equals(Object obj) {
        return obj instanceof XmlTagDelegate && ((XmlTagDelegate)obj).myTag == this.myTag;
    }

    public int hashCode() {
        return this.myTag.hashCode();
    }

    @Nullable
    private static XmlNSDescriptor getDtdDescriptor(@NotNull XmlFile containingFile) {
        XmlDocument document = containingFile.getDocument();
        if (document == null) {
            return null;
        }
        String url = XmlUtil.getDtdUri(document);
        if (url == null) {
            return null;
        }
        return document.getDefaultNSDescriptor(url, true);
    }

    @Nullable
    private static String getNSVersion(@Nullable String ns, @NotNull XmlTag xmlTag) {
        String versionValue = xmlTag.getAttributeValue("version");
        if (versionValue != null && xmlTag.getNamespace().equals(ns)) {
            return versionValue;
        }
        return null;
    }

    PsiReference @NotNull [] getDefaultReferences(@NotNull PsiReferenceService.Hints hints) {
        ProgressManager.checkCanceled();
        if (hints == PsiReferenceService.Hints.NO_HINTS) {
            return (PsiReference[])((PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this.myTag, () -> CachedValueProvider.Result.create((Object)this.getReferencesImpl(PsiReferenceService.Hints.NO_HINTS), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, XmlTagDelegate.externalResourceModificationTracker(this.myTag)}))).clone();
        }
        return this.getReferencesImpl(hints);
    }

    private PsiReference @NotNull [] getReferencesImpl(@NotNull PsiReferenceService.Hints hints) {
        boolean inEndTag;
        boolean inStartTag;
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myTag.getNode());
        if (startTagName == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this.myTag.getNode());
        SmartList refs = new SmartList();
        String prefix = this.myTag.getNamespacePrefix();
        boolean bl = inStartTag = hints.offsetInElement == null || XmlTagDelegate.childContainsOffset(startTagName.getPsi(), hints.offsetInElement);
        if (inStartTag) {
            TagNameReference startTagRef = TagNameReference.createTagNameReference((XmlElement)this.myTag, startTagName, true);
            if (startTagRef != null) {
                refs.add(startTagRef);
            }
            if (!prefix.isEmpty()) {
                refs.addAll(this.createPrefixReferences(startTagName, prefix, startTagRef));
            }
        }
        boolean bl2 = inEndTag = endTagName != null && (hints.offsetInElement == null || XmlTagDelegate.childContainsOffset(endTagName.getPsi(), hints.offsetInElement));
        if (inEndTag) {
            TagNameReference endTagRef = TagNameReference.createTagNameReference((XmlElement)this.myTag, endTagName, false);
            if (endTagRef != null) {
                refs.add(endTagRef);
            }
            if (StringUtil.isNotEmpty((String)(prefix = this.getNamespacePrefix(endTagName.getText())))) {
                refs.addAll(this.createPrefixReferences(endTagName, prefix, endTagRef));
            }
        }
        if (hints.offsetInElement == null || inStartTag || inEndTag || this.isInsideXmlText(hints.offsetInElement)) {
            Collections.addAll(refs, ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myTag, (PsiReferenceService.Hints)hints));
        }
        return refs.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static boolean childContainsOffset(@NotNull PsiElement child, int offsetInTag) {
        return child.getStartOffsetInParent() <= offsetInTag && offsetInTag <= child.getStartOffsetInParent() + child.getTextLength();
    }

    private boolean isInsideXmlText(int offsetInTag) {
        TextRange[] ranges = this.getValueTextRanges();
        if (ranges.length == 0) {
            return false;
        }
        if (offsetInTag < ranges[0].getStartOffset() || offsetInTag > ranges[ranges.length - 1].getEndOffset()) {
            return false;
        }
        int i = Arrays.binarySearch(ranges, TextRange.from((int)offsetInTag, (int)0), RANGE_COMPARATOR);
        return i >= 0 || ranges[-i - 2].containsOffset(offsetInTag);
    }

    private TextRange @NotNull [] getValueTextRanges() {
        TextRange[] elements = this.myTextElements;
        if (elements == null) {
            SmartList list = new SmartList();
            for (ASTNode child = this.myTag.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                PsiElement psi = child.getPsi();
                if (!(psi instanceof XmlText)) continue;
                list.add(TextRange.from((int)psi.getStartOffsetInParent(), (int)psi.getTextLength()));
            }
            this.myTextElements = elements = list.toArray(TextRange.EMPTY_ARRAY);
        }
        return elements;
    }

    protected Collection<PsiReference> createPrefixReferences(@NotNull ASTNode startTagName, @NotNull String prefix, @Nullable TagNameReference tagRef) {
        return Collections.singleton(new SchemaPrefixReference((XmlElement)this.myTag, TextRange.from((int)(startTagName.getStartOffset() - this.myTag.getNode().getStartOffset()), (int)prefix.length()), prefix, tagRef));
    }

    XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        XmlNSDescriptor value;
        XmlNSDescriptor descriptor;
        XmlTag parentTag = this.myTag.getParentTag();
        if (parentTag == null && namespace.equals("http://www.w3.org/1999/xhtml") && (descriptor = XmlTagDelegate.getDtdDescriptor(XmlUtil.getContainingFile((PsiElement)this.myTag))) != null) {
            return descriptor;
        }
        descriptor = this.getNSDescriptorMap().get(namespace);
        if (descriptor != null && (value = (XmlNSDescriptor)descriptor.getValue()) != null) {
            return value;
        }
        if (parentTag == null) {
            XmlDocument parentOfType = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this.myTag, XmlDocument.class);
            if (parentOfType == null) {
                return null;
            }
            return parentOfType.getDefaultNSDescriptor(namespace, strict);
        }
        return parentTag.getNSDescriptor(namespace, strict);
    }

    void collapseIfEmpty() {
        XmlTag[] tags = this.myTag.getSubTags();
        if (tags.length > 0) {
            return;
        }
        ASTNode closingName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this.myTag.getNode());
        ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(this.myTag.getNode());
        if (closingName == null || startTagEnd == null) {
            return;
        }
        ASTNode closingBracket = closingName.getTreeNext();
        ASTNode tag = this.myTag.getNode();
        tag.removeRange(startTagEnd, closingBracket);
        LeafElement emptyTagEnd = Factory.createSingleLeafElement((IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END, (CharSequence)"/>", (int)0, (int)2, null, (PsiManager)this.myTag.getManager());
        tag.replaceChild(closingBracket, (ASTNode)emptyTagEnd);
    }

    @NotNull
    private Map<String, NullableLazyValue<XmlNSDescriptor>> getNSDescriptorMap() {
        XmlTag tag = this.myTag;
        return (Map)CachedValuesManager.getCachedValue((PsiElement)tag, () -> CachedValueProvider.Result.create(XmlTagDelegate.computeNsDescriptorMap(tag), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, XmlTagDelegate.externalResourceModificationTracker(tag)}));
    }

    @NotNull
    protected String getNamespacePrefix(@NotNull String name) {
        return XmlUtil.findPrefixByQualifiedName(name);
    }

    @NotNull
    private static Map<String, NullableLazyValue<XmlNSDescriptor>> computeNsDescriptorMap(@NotNull XmlTag tag) {
        Map<String, NullableLazyValue<XmlNSDescriptor>> map = null;
        String noNamespaceDeclaration = tag.getAttributeValue("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        String schemaLocationDeclaration = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        boolean hasNamespaceDeclarations = tag.hasNamespaceDeclarations();
        if (noNamespaceDeclaration != null) {
            map = XmlTagDelegate.initializeSchema(tag, "", null, Collections.singleton(noNamespaceDeclaration), null, hasNamespaceDeclarations);
        }
        if (schemaLocationDeclaration != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                map = XmlTagDelegate.initializeSchema(tag, uri, XmlTagDelegate.getNSVersion(uri, tag), Collections.singleton(tokenizer.nextToken()), map, hasNamespaceDeclarations);
            }
        }
        if (hasNamespaceDeclarations) {
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String ns = attribute.getValue();
                if (ns == null) {
                    ns = "";
                }
                ns = tag.getRealNs(ns);
                if (map != null && map.containsKey(ns)) continue;
                Set<String> locations = XmlTagDelegate.getNsLocations(tag, ns);
                map = XmlTagDelegate.initializeSchema(tag, ns, XmlTagDelegate.getNSVersion(ns, tag), locations, map, true);
            }
        }
        return map == null ? Collections.emptyMap() : map;
    }

    @NotNull
    private static Map<String, NullableLazyValue<XmlNSDescriptor>> initializeSchema(@NotNull XmlTag tag, @Nullable String namespace, @Nullable String version, @NotNull Set<String> fileLocations, @Nullable Map<String, NullableLazyValue<XmlNSDescriptor>> map, boolean nsDecl) {
        if (map == null) {
            map = new THashMap();
        }
        map.put(namespace, NullableLazyValue.createValue(() -> {
            List descriptors = ContainerUtil.mapNotNull((Collection)fileLocations, s -> XmlTagDelegate.getDescriptor(tag, XmlTagDelegate.retrieveFile(tag, s, version, namespace, nsDecl), s, namespace));
            XmlNSDescriptor descriptor = null;
            if (descriptors.size() == 1) {
                descriptor = (XmlNSDescriptor)descriptors.get(0);
            } else if (descriptors.size() > 1) {
                descriptor = new MultiFileNsDescriptor(ContainerUtil.map((Collection)descriptors, descriptor1 -> (XmlNSDescriptorImpl)descriptor1));
            }
            if (descriptor == null) {
                return null;
            }
            XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)tag);
            if (extension != null) {
                String prefix = tag.getPrefixByNamespace(namespace);
                descriptor = extension.wrapNSDescriptor(tag, (String)ObjectUtils.notNull((Object)prefix, (Object)""), descriptor);
            }
            return descriptor;
        }));
        return map;
    }

    @Nullable
    private static XmlNSDescriptor getDescriptor(@NotNull XmlTag tag, @Nullable XmlFile currentFile, @NotNull String fileLocation, @Nullable String namespace) {
        PsiMetaOwner currentOwner;
        XmlDocument document;
        XmlNSDescriptor descriptor = XmlTagDelegate.getImplicitNamespaceDescriptor(tag, fileLocation);
        if (descriptor != null) {
            return descriptor;
        }
        if (currentFile == null && (document = XmlUtil.getContainingFile((PsiElement)tag).getDocument()) != null) {
            String defaultValue;
            XmlAttributeDescriptor attributeDescriptor;
            XmlElementDescriptor elementDescriptor;
            String uri = XmlUtil.getDtdUri(document);
            if (uri != null) {
                XmlFile containingFile = XmlUtil.getContainingFile((PsiElement)document);
                XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, uri);
                XmlNSDescriptor xmlNSDescriptor = descriptor = xmlFile == null ? null : (XmlNSDescriptor)ObjectUtils.doIfNotNull((Object)xmlFile.getDocument(), PsiMetaOwner::getMetaData);
            }
            if (descriptor instanceof com.intellij.xml.impl.dtd.XmlNSDescriptorImpl && (elementDescriptor = descriptor.getElementDescriptor(tag)) != null && (attributeDescriptor = elementDescriptor.getAttributeDescriptor("xmlns", tag)) != null && attributeDescriptor.isFixed() && (defaultValue = attributeDescriptor.getDefaultValue()) != null && defaultValue.equals(namespace)) {
                return descriptor;
            }
        }
        if ((currentOwner = XmlTagDelegate.retrieveOwner(tag, currentFile, namespace)) != null) {
            return (XmlNSDescriptor)currentOwner.getMetaData();
        }
        return null;
    }

    @Nullable
    private static XmlNSDescriptor getImplicitNamespaceDescriptor(@NotNull XmlTag tag, @NotNull String ns) {
        PsiFile file = tag.getContainingFile();
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            for (ImplicitNamespaceDescriptorProvider provider : ImplicitNamespaceDescriptorProvider.EP_NAME.getExtensionList()) {
                XmlNSDescriptor nsDescriptor = provider.getNamespaceDescriptor(module, ns, file);
                if (nsDescriptor == null) continue;
                return nsDescriptor;
            }
        }
        return null;
    }

    @Nullable
    private static XmlFile retrieveFile(@Nullable XmlTag tag, @NotNull String fileLocation, @Nullable String version, String namespace, boolean nsDecl) {
        String targetNs = XmlUtil.getTargetSchemaNsFromTag(tag);
        if (fileLocation.equals(targetNs)) {
            return null;
        }
        XmlFile file = XmlUtil.getContainingFile((PsiElement)tag);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = ExternalResourceManager.getInstance().getResourceLocation(fileLocation, (PsiFile)file, version);
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return XmlNamespaceIndex.guessSchema(namespace, nsDecl ? null : tag.getLocalName(), version, fileLocation, (PsiFile)file);
    }

    @Nullable
    private static PsiMetaOwner retrieveOwner(@Nullable XmlTag tag, @Nullable XmlFile file, @Nullable String namespace) {
        if (file == null) {
            return namespace != null && namespace.equals(XmlUtil.getTargetSchemaNsFromTag(tag)) ? tag : null;
        }
        return (PsiMetaOwner)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> ((XmlFile)file).getDocument());
    }

    @Nullable
    XmlElementDescriptor getDescriptor() {
        return (XmlElementDescriptor)CachedValuesManager.getCachedValue((PsiElement)this.myTag, (CachedValueProvider)new CachedValueProvider<XmlElementDescriptor>(){

            public CachedValueProvider.Result<XmlElementDescriptor> compute() {
                XmlElementDescriptor descriptor = (XmlElementDescriptor)RecursionManager.doPreventingRecursion((Object)XmlTagDelegate.this.myTag, (boolean)true, XmlTagDelegate.this::computeElementDescriptor);
                return CachedValueProvider.Result.create((Object)descriptor, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, XmlTagDelegate.externalResourceModificationTracker(XmlTagDelegate.this.myTag)});
            }

            public String toString() {
                return "XmlTag.getDescriptor(" + XmlTagDelegate.this.myTag.getText() + ")";
            }
        });
    }

    @NotNull
    private static ModificationTracker externalResourceModificationTracker(@NotNull XmlTag tag) {
        Project project = tag.getProject();
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        return () -> manager.getModificationCount(project);
    }

    @Nullable
    protected XmlElementDescriptor computeElementDescriptor() {
        XmlElementDescriptor fromParent;
        XmlElementDescriptor descriptor;
        XmlTag parent;
        for (XmlElementDescriptorProvider provider : XmlElementDescriptorProvider.EP_NAME.getExtensionList()) {
            XmlElementDescriptor elementDescriptor = provider.getDescriptor(this.myTag);
            if (elementDescriptor == null) continue;
            return elementDescriptor;
        }
        String namespace = this.myTag.getNamespace();
        if ("".equals(namespace) && (parent = this.myTag.getParentTag()) != null && (descriptor = parent.getDescriptor()) != null && (fromParent = descriptor.getElementDescriptor(this.myTag, parent)) != null && !(fromParent instanceof AnyXmlElementDescriptor)) {
            return fromParent;
        }
        XmlElementDescriptor elementDescriptor = null;
        XmlNSDescriptor nsDescriptor = this.myTag.getNSDescriptor(namespace, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor for namespace " + namespace + " is " + (nsDescriptor != null ? nsDescriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (nsDescriptor != null && (!DumbService.getInstance((Project)this.myTag.getProject()).isDumb() || DumbService.isDumbAware((Object)nsDescriptor))) {
            elementDescriptor = nsDescriptor.getElementDescriptor(this.myTag);
        }
        if (elementDescriptor == null) {
            return XmlUtil.findXmlDescriptorByType(this.myTag);
        }
        return elementDescriptor;
    }

    @NotNull
    String getName() {
        String name = this.myName;
        if (name == null) {
            ASTNode nameElement = XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myTag.getNode());
            name = nameElement != null ? nameElement.getText() : "";
            this.myName = name;
        }
        return name;
    }

    @NotNull
    PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        TreeElement treeElement;
        XmlTag dummyTag = this.createTag(name, "aa");
        ASTNode tag = this.myTag.getNode();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)tag);
        ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag);
        LOG.assertTrue(child != null, (Object)("It seems '" + name + "' is not a valid tag name"));
        TreeElement tagElement = (TreeElement)XmlChildRole.START_TAG_NAME_FINDER.findChild(dummyTag.getNode());
        LOG.assertTrue(tagElement != null, (Object)("What's wrong with it? '" + name + "'"));
        tag.replaceChild(child, (ASTNode)ChangeUtil.copyElement((TreeElement)tagElement, (CharTable)charTableByTree));
        ASTNode childByRole = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag);
        if (childByRole != null && (treeElement = (TreeElement)XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(dummyTag.getNode())) != null) {
            tag.replaceChild(childByRole, (ASTNode)ChangeUtil.copyElement((TreeElement)treeElement, (CharTable)charTableByTree));
        }
        return this.myTag;
    }

    private void processChildren(@NotNull PsiElementProcessor<? super PsiElement> processor) {
        XmlPsiUtil.processXmlElementChildren((XmlElement)this.myTag, processor, false);
    }

    XmlAttribute @NotNull [] calculateAttributes() {
        ArrayList result = new ArrayList(10);
        this.processChildren((PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            if (element instanceof XmlAttribute) {
                result.add((XmlAttribute)element);
            }
            return !(element instanceof XmlToken) || ((XmlToken)element).getTokenType() != XmlTokenType.XML_TAG_END;
        }));
        return result.toArray(XmlAttribute.EMPTY_ARRAY);
    }

    @Contract(value="null->null")
    protected String getAttributeValue(String qname) {
        THashMap map = this.myAttributeValueMap;
        if (map == null) {
            map = new THashMap();
            for (XmlAttribute attribute : this.myTag.getAttributes()) {
                this.cacheOneAttributeValue(attribute.getName(), attribute.getValue(), (Map<String, String>)map);
            }
            this.myAttributeValueMap = map;
        }
        return map.get(qname);
    }

    @Nullable
    protected String getAttributeValue(@Nullable String _name, @Nullable String namespace) {
        if (namespace == null) {
            return this.myTag.getAttributeValue(_name);
        }
        XmlTag current = this.myTag;
        while (true) {
            PsiElement parent;
            List keysByValue;
            BidirectionalMap<String, String> map;
            if ((map = XmlTagDelegate.getNamespaceMap(current)) != null && (keysByValue = map.getKeysByValue((Object)namespace)) != null && !keysByValue.isEmpty()) {
                for (String prefix : keysByValue) {
                    String value;
                    if (prefix == null || prefix.isEmpty() || (value = this.myTag.getAttributeValue(prefix + ":" + _name)) == null) continue;
                    return value;
                }
            }
            if (!((parent = current.getParent()) instanceof XmlTag)) break;
            current = (XmlTag)parent;
        }
        if (namespace.isEmpty() || this.myTag.getNamespace().equals(namespace)) {
            return this.myTag.getAttributeValue(_name);
        }
        return null;
    }

    XmlTag @NotNull [] getSubTags(boolean processIncludes) {
        Key<CachedValue<XmlTag[]>> key = processIncludes ? SUBTAGS_WITH_INCLUDES_KEY : SUBTAGS_WITHOUT_INCLUDES_KEY;
        XmlTag[] cached = (XmlTag[])CachedValuesManager.getCachedValue((PsiElement)this.myTag, key, () -> CachedValueProvider.Result.create((Object)this.calcSubTags(processIncludes), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return (XmlTag[])cached.clone();
    }

    protected XmlTag @NotNull [] calcSubTags(boolean processIncludes) {
        ArrayList result = new ArrayList();
        XmlPsiUtil.processXmlElements((XmlElement)this.myTag, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            if (element instanceof XmlTag) {
                PsiUtilCore.ensureValid((PsiElement)element);
                result.add((XmlTag)element);
            }
            return true;
        }), false, false, this.myTag.getContainingFile(), processIncludes);
        return result.toArray(XmlTag.EMPTY);
    }

    protected XmlTag @NotNull [] findSubTags(@NotNull String name, @Nullable String namespace) {
        XmlTag[] subTags = this.myTag.getSubTags();
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (XmlTag subTag : subTags) {
            if (namespace == null) {
                if (!name.equals(subTag.getName())) continue;
                result.add(subTag);
                continue;
            }
            if (!name.equals(subTag.getLocalName()) || !namespace.equals(subTag.getNamespace())) continue;
            result.add(subTag);
        }
        return result.toArray(XmlTag.EMPTY);
    }

    @Nullable
    XmlTag findFirstSubTag(@NotNull String name) {
        XmlTag[] subTags = this.myTag.findSubTags(name);
        if (subTags.length > 0) {
            return subTags[0];
        }
        return null;
    }

    @Nullable
    XmlAttribute getAttribute(@Nullable String name, @Nullable String namespace) {
        if (name != null && name.indexOf(58) != -1 || namespace == null || "".equals(namespace)) {
            return this.myTag.getAttribute(name);
        }
        String prefix = this.myTag.getPrefixByNamespace(namespace);
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        return this.myTag.getAttribute(prefix + ":" + name);
    }

    @Nullable
    XmlAttribute getAttribute(@Nullable String qname) {
        if (qname == null) {
            return null;
        }
        XmlAttribute[] attributes = this.myTag.getAttributes();
        boolean caseSensitive = this.myTag.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            if (!(child instanceof LeafElement)) continue;
            LeafElement attrNameElement = (LeafElement)child;
            if ((!caseSensitive || !Comparing.equal((CharSequence)attrNameElement.getChars(), (CharSequence)qname)) && (caseSensitive || !Comparing.equal((CharSequence)attrNameElement.getChars(), (CharSequence)qname, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    @NotNull
    protected String getNamespaceByPrefix(String prefix) {
        String result;
        String ns;
        BidirectionalMap<String, String> map = XmlTagDelegate.getNamespaceMap(this.myTag);
        if (map != null && (ns = (String)map.get((Object)prefix)) != null) {
            return ns;
        }
        XmlTag parentTag = this.myTag.getParentTag();
        if (parentTag != null) {
            return parentTag.getNamespaceByPrefix(prefix);
        }
        if (XML_NS_PREFIX.equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (!prefix.isEmpty() && !this.myTag.hasNamespaceDeclarations() && this.myTag.getNamespacePrefix().equals(prefix) && (result = (String)RecursionManager.doPreventingRecursion((Object)Trinity.create((Object)"getNsByPrefix", (Object)this.myTag, (Object)prefix), (boolean)true, () -> {
            String nameFromRealDescriptor;
            String nsFromEmptyPrefix = this.myTag.getNamespaceByPrefix("");
            if (nsFromEmptyPrefix.isEmpty()) {
                return nsFromEmptyPrefix;
            }
            XmlNSDescriptor nsDescriptor = this.myTag.getNSDescriptor(nsFromEmptyPrefix, false);
            XmlElementDescriptor descriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(this.myTag) : null;
            String string = nameFromRealDescriptor = descriptor != null && descriptor.getDeclaration() != null && descriptor.getDeclaration().isPhysical() ? descriptor.getName() : "";
            if (nameFromRealDescriptor.equals(this.myTag.getName())) {
                return nsFromEmptyPrefix;
            }
            return "";
        })) != null) {
            return result;
        }
        return "";
    }

    @Nullable
    protected String getPrefixByNamespace(@Nullable String namespace) {
        XmlTag parentTag;
        BidirectionalMap<String, String> map = XmlTagDelegate.getNamespaceMap(this.myTag);
        if (map != null) {
            String ns;
            List keysByValue = map.getKeysByValue((Object)namespace);
            String string = ns = keysByValue == null || keysByValue.isEmpty() ? null : (String)keysByValue.get(0);
            if (ns != null) {
                return ns;
            }
        }
        if ((parentTag = this.myTag.getParentTag()) != null) {
            return parentTag.getPrefixByNamespace(namespace);
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return XML_NS_PREFIX;
        }
        return null;
    }

    String @NotNull [] knownNamespaces() {
        PsiElement parentElement = this.myTag.getParent();
        BidirectionalMap<String, String> map = XmlTagDelegate.getNamespaceMap(this.myTag);
        Set known = Collections.emptySet();
        if (map != null) {
            known = new HashSet(map.values());
        }
        if (parentElement instanceof XmlTag) {
            if (known.isEmpty()) {
                return ((XmlTag)parentElement).knownNamespaces();
            }
            ContainerUtil.addAll(known, (Object[])((XmlTag)parentElement).knownNamespaces());
        } else {
            XmlTag rootTag;
            XmlFile xmlFile;
            XmlExtension xmlExtension = XmlExtension.getExtensionByElement((PsiElement)this.myTag);
            if (xmlExtension != null && (xmlFile = xmlExtension.getContainingFile((PsiElement)this.myTag)) != null && (rootTag = xmlFile.getRootTag()) != null && rootTag != this.myTag) {
                if (known.isEmpty()) {
                    return rootTag.knownNamespaces();
                }
                ContainerUtil.addAll(known, (Object[])rootTag.knownNamespaces());
            }
        }
        return ArrayUtilRt.toStringArray(known);
    }

    @Nullable
    private static BidirectionalMap<String, String> getNamespaceMap(@NotNull XmlTag tag) {
        return (BidirectionalMap)CachedValuesManager.getCachedValue((PsiElement)tag, () -> CachedValueProvider.Result.create(XmlTagDelegate.computeNamespaceMap(tag), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static BidirectionalMap<String, String> computeNamespaceMap(@NotNull XmlTag tag) {
        String[][] namespacesFromDocument;
        XmlExtension extension;
        BidirectionalMap map = null;
        PsiElement parent = tag.getParent();
        boolean hasNamespaceDeclarations = tag.hasNamespaceDeclarations();
        if (hasNamespaceDeclarations) {
            XmlAttribute[] attributes;
            map = new BidirectionalMap();
            for (XmlAttribute attribute : attributes = tag.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String name = attribute.getName();
                int splitIndex = name.indexOf(58);
                String value = tag.getRealNs(attribute.getValue());
                if (value == null) continue;
                if (splitIndex < 0) {
                    map.put((Object)"", (Object)value);
                    continue;
                }
                map.put((Object)XmlUtil.findLocalNameByQualifiedName(name), (Object)value);
            }
        }
        if (parent instanceof XmlDocument && (extension = XmlExtension.getExtensionByElement(parent)) != null && (namespacesFromDocument = extension.getNamespacesFromDocument((XmlDocument)parent, hasNamespaceDeclarations)) != null) {
            if (map == null) {
                map = new BidirectionalMap();
            }
            for (String[] prefix2ns : namespacesFromDocument) {
                if (map.containsKey((Object)prefix2ns[0])) continue;
                map.put((Object)prefix2ns[0], (Object)tag.getRealNs(prefix2ns[1]));
            }
        }
        return map;
    }

    @NotNull
    private static Set<String> getNsLocations(@NotNull XmlTag tag, @Nullable String ns) {
        if ("http://www.w3.org/1999/xhtml".equals(ns)) {
            return Collections.singleton(XmlUtil.getDefaultXhtmlNamespace(tag.getProject()));
        }
        HashSet<String> locations = new HashSet<String>();
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "schema") && ns != null) {
            for (XmlTag subTag : tag.getSubTags()) {
                if (!XmlNSDescriptorImpl.equalsToSchemaName(subTag, "import") || !ns.equals(subTag.getAttributeValue("namespace"))) continue;
                String location = subTag.getAttributeValue("schemaLocation");
                ContainerUtil.addIfNotNull(locations, (Object)location);
            }
        }
        if (locations.isEmpty()) {
            locations.add(XmlUtil.getSchemaLocation(tag, ns));
        }
        return locations;
    }

    @NotNull
    String getLocalName() {
        String localName = this.myLocalName;
        if (localName == null) {
            String name = this.myTag.getName();
            this.myLocalName = localName = name.substring(name.indexOf(58) + 1);
        }
        return localName;
    }

    boolean hasNamespaceDeclarations() {
        Boolean result = this.myHasNamespaceDeclarations;
        if (result == null) {
            this.myHasNamespaceDeclarations = result = this.calculateHasNamespaceDeclarations();
        }
        return result;
    }

    @NotNull
    private Boolean calculateHasNamespaceDeclarations() {
        Ref result = new Ref((Object)Boolean.FALSE);
        this.processChildren((PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            if (element instanceof XmlAttribute && ((XmlAttribute)element).isNamespaceDeclaration()) {
                result.set((Object)Boolean.TRUE);
                return false;
            }
            return !(element instanceof XmlToken) || ((XmlToken)element).getTokenType() != XmlTokenType.XML_TAG_END;
        }));
        return (Boolean)result.get();
    }

    @NotNull
    Map<String, String> getLocalNamespaceDeclarations() {
        THashMap namespaces = new THashMap();
        for (XmlAttribute attribute : this.myTag.getAttributes()) {
            if (!attribute.isNamespaceDeclaration() || attribute.getValue() == null) continue;
            String localName = attribute.getLocalName();
            namespaces.put(localName.equals(attribute.getName()) ? "" : localName, attribute.getValue());
        }
        return namespaces;
    }

    @Nullable
    XmlAttribute setAttribute(String qname, @Nullable String value) throws IncorrectOperationException {
        XmlAttribute attribute = this.myTag.getAttribute(qname);
        if (attribute != null) {
            if (value == null) {
                this.deleteChildInternal(attribute.getNode());
                return null;
            }
            attribute.setValue(value);
            return attribute;
        }
        if (value == null) {
            return null;
        }
        PsiElement xmlAttribute = this.myTag.add((PsiElement)this.createAttribute(qname, value));
        while (!(xmlAttribute instanceof XmlAttribute)) {
            xmlAttribute = xmlAttribute.getNextSibling();
        }
        return (XmlAttribute)xmlAttribute;
    }

    XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        String prefix;
        if (!Objects.equals(namespace, "") && (prefix = this.myTag.getPrefixByNamespace(namespace)) != null && !prefix.isEmpty()) {
            name = prefix + ":" + name;
        }
        return this.myTag.setAttribute(name, value);
    }

    @NotNull
    XmlTag addSubTag(@NotNull XmlTag subTag, boolean first) {
        Object[] children = this.myTag.getSubTags();
        if (children.length == 0) {
            children = this.myTag.getValue().getChildren();
        }
        if (children.length == 0) {
            return (XmlTag)this.myTag.add((PsiElement)subTag);
        }
        if (first) {
            return (XmlTag)this.myTag.addBefore((PsiElement)subTag, (PsiElement)children[0]);
        }
        return (XmlTag)this.myTag.addAfter((PsiElement)subTag, (PsiElement)ArrayUtil.getLastElement((Object[])children));
    }

    void deleteChildInternal(@NotNull ASTNode child) {
        if (child.getElementType() instanceof IXmlAttributeElementType) {
            try {
                this.deleteChildInternalSuper(child);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        } else {
            ASTNode treePrev = child.getTreePrev();
            ASTNode treeNext = child.getTreeNext();
            this.deleteChildInternalSuper(child);
            if (treePrev != null && treeNext != null && treePrev.getElementType() == XmlElementType.XML_TEXT && treeNext.getElementType() == XmlElementType.XML_TEXT && !TreeUtil.containsOuterLanguageElements((ASTNode)treePrev) && !TreeUtil.containsOuterLanguageElements((ASTNode)treeNext)) {
                XmlText prevText = (XmlText)treePrev.getPsi();
                XmlText nextText = (XmlText)treeNext.getPsi();
                String newValue = prevText.getValue() + nextText.getValue();
                ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                    PsiElement anchor = prevText.getPrevSibling();
                    prevText.delete();
                    nextText.delete();
                    XmlText text = (XmlText)this.myTag.addAfter((PsiElement)XmlElementFactory.getInstance((Project)this.myTag.getProject()).createDisplayText("x"), anchor);
                    text.setValue(newValue);
                }, (TreeElement)((TreeElement)this.myTag.getNode()));
            }
        }
    }

    TreeElement addInternal(@NotNull TreeElement child, @Nullable ASTNode anchor, boolean before) throws IncorrectOperationException {
        if (anchor != null && child.getElementType() == XmlElementType.XML_TEXT) {
            XmlText psi = null;
            if (anchor.getPsi() instanceof XmlText) {
                psi = (XmlText)anchor.getPsi();
            } else {
                ASTNode other;
                ASTNode aSTNode = other = before ? anchor.getTreePrev() : anchor.getTreeNext();
                if (other != null && other.getPsi() instanceof XmlText) {
                    before = !before;
                    psi = (XmlText)other.getPsi();
                }
            }
            if (psi != null) {
                if (before) {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), 0);
                } else {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), psi.getValue().length());
                }
                return (TreeElement)psi.getNode();
            }
        }
        LOG.assertTrue(child.getPsi() instanceof XmlAttribute || child.getPsi() instanceof XmlTagChild);
        return child.getElementType() instanceof IXmlAttributeElementType ? this.insertAttribute(anchor, child, before) : (anchor == null ? this.bodyInsert(child) : this.genericInsert(child, anchor, before));
    }

    @NotNull
    private ASTNode expandTag() throws IncorrectOperationException {
        ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myTag.getNode());
        if (endTagStart == null) {
            XmlTag tagFromText = this.createTagFromText("<" + this.myTag.getName() + "></" + this.myTag.getName() + ">");
            ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(tagFromText.getNode());
            endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tagFromText.getNode());
            assert (startTagStart != null) : tagFromText.getText();
            assert (endTagStart != null) : tagFromText.getText();
            LeafElement emptyTagEnd = (LeafElement)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(this.myTag.getNode());
            if (emptyTagEnd != null) {
                this.myTag.getNode().removeChild((ASTNode)emptyTagEnd);
            }
            this.myTag.getNode().addChildren(startTagStart, null, null);
        }
        return endTagStart;
    }

    protected TreeElement bodyInsert(TreeElement child) {
        ASTNode anchor = this.expandTag();
        if (child.getElementType() == XmlElementType.XML_TAG) {
            PsiElement declaration;
            XmlTag[] subTags = this.myTag.getSubTags();
            XmlElementDescriptor parentDescriptor = this.myTag.getDescriptor();
            PsiElement psiElement = declaration = parentDescriptor != null ? parentDescriptor.getDeclaration() : null;
            if (declaration != null && declaration.getContainingFile() != null && declaration.getContainingFile().isPhysical() && subTags.length > 0) {
                XmlElementDescriptor[] childElementDescriptors = parentDescriptor.getElementsDescriptors(this.myTag);
                int subTagNum = -1;
                for (XmlElementDescriptor childElementDescriptor : childElementDescriptors) {
                    String childElementName = childElementDescriptor.getName();
                    while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                        ++subTagNum;
                    }
                    ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild((ASTNode)child);
                    if (startTagName == null || !childElementName.equals(startTagName.getText())) continue;
                    if (subTagNum >= 0) {
                        ASTNode subTag = subTags[subTagNum].getNode();
                        if (subTag.getTreeParent() != this.myTag.getNode()) {
                            XmlEntityRef entityRef = (XmlEntityRef)PsiTreeUtil.getParentOfType((PsiElement)subTags[subTagNum], XmlEntityRef.class);
                            throw new IncorrectOperationException("Can't insert subtag to the entity. Entity reference text: " + (entityRef == null ? "" : entityRef.getText()));
                        }
                        return this.addInternalSuper(child, (ASTNode)child, subTag, Boolean.FALSE);
                    }
                    ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(this.myTag.getNode());
                    return this.addInternalSuper(child, (ASTNode)child, startTagEnd, Boolean.FALSE);
                }
            } else {
                ASTNode closingTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myTag.getNode());
                return this.addInternalSuper(child, (ASTNode)child, closingTagStart, Boolean.TRUE);
            }
        }
        return this.addInternalSuper(child, (ASTNode)child, anchor, Boolean.TRUE);
    }

    private TreeElement insertAttribute(ASTNode anchor, TreeElement child, boolean before) {
        if (anchor == null) {
            ASTNode tagNode = this.myTag.getNode();
            ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tagNode);
            if (startTagEnd == null) {
                startTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tagNode);
            }
            if (startTagEnd == null) {
                anchor = tagNode.getLastChildNode();
                while (anchor instanceof PsiWhiteSpace) {
                    anchor = anchor.getTreePrev();
                }
                if (anchor instanceof PsiErrorElement) {
                    LeafElement token = Factory.createSingleLeafElement((IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END, (CharSequence)"/>", (int)0, (int)2, (CharTable)SharedImplUtil.findCharTableByTree((ASTNode)anchor), (PsiManager)this.myTag.getManager());
                    tagNode.replaceChild(anchor, (ASTNode)token);
                    startTagEnd = token;
                }
            }
            if (startTagEnd == null) {
                anchor = XmlChildRole.START_TAG_NAME_FINDER.findChild(tagNode);
                return this.addInternalSuper(child, (ASTNode)child, anchor, Boolean.FALSE);
            }
            return this.addInternalSuper(child, (ASTNode)child, startTagEnd, Boolean.TRUE);
        }
        return this.genericInsert(child, anchor, before);
    }

    protected TreeElement genericInsert(TreeElement child, ASTNode anchor, boolean before) {
        return this.addInternalSuper(child, (ASTNode)child, anchor, before);
    }
}

